/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;

class Type3FontOperator
extends ContentOperator {
    static final int d0 = 1;
    static final int d1 = 2;

    Type3FontOperator(int type, ASName name) {
        super(type, name);
    }

    @Override
    public void process(Instruction instruction, IOperatorHandler opHandlers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OperandStack opStack = instruction.getReadonlyOperands();
        switch (this.getType()) {
            case 1: {
                double wy = opStack.popNumber().doubleValue();
                double wx = opStack.popNumber().doubleValue();
                opHandlers.d0(wx, wy, instruction);
                break;
            }
            case 2: {
                double ury = opStack.popNumber().doubleValue();
                double urx = opStack.popNumber().doubleValue();
                double lly = opStack.popNumber().doubleValue();
                double llx = opStack.popNumber().doubleValue();
                double wy1 = opStack.popNumber().doubleValue();
                double wx1 = opStack.popNumber().doubleValue();
                opHandlers.d1(wx1, wy1, llx, lly, urx, ury, instruction);
            }
        }
    }
}

