/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;

class PathConstructionOperator
extends ContentOperator {
    static final int m = 1;
    static final int l = 2;
    static final int c = 3;
    static final int v = 4;
    static final int y = 5;
    static final int h = 6;
    static final int re = 7;

    PathConstructionOperator(int type, ASName name) {
        super(type, name);
    }

    @Override
    public void process(Instruction instruction, IOperatorHandler opHandlers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        OperandStack opStack = instruction.getReadonlyOperands();
        switch (this.getType()) {
            case 1: {
                double y1 = opStack.popNumber().doubleValue();
                double x = opStack.popNumber().doubleValue();
                opHandlers.m(x, y1, instruction);
                break;
            }
            case 2: {
                double y1 = opStack.popNumber().doubleValue();
                double x = opStack.popNumber().doubleValue();
                opHandlers.l(x, y1, instruction);
                break;
            }
            case 3: {
                double y3 = opStack.popNumber().doubleValue();
                double x3 = opStack.popNumber().doubleValue();
                double y2 = opStack.popNumber().doubleValue();
                double x2 = opStack.popNumber().doubleValue();
                double y1 = opStack.popNumber().doubleValue();
                double x1 = opStack.popNumber().doubleValue();
                opHandlers.c(x1, y1, x2, y2, x3, y3, instruction);
                break;
            }
            case 4: {
                double y3 = opStack.popNumber().doubleValue();
                double x3 = opStack.popNumber().doubleValue();
                double y2 = opStack.popNumber().doubleValue();
                double x2 = opStack.popNumber().doubleValue();
                opHandlers.v(x2, y2, x3, y3, instruction);
                break;
            }
            case 5: {
                double y3 = opStack.popNumber().doubleValue();
                double x3 = opStack.popNumber().doubleValue();
                double y1 = opStack.popNumber().doubleValue();
                double x1 = opStack.popNumber().doubleValue();
                opHandlers.y(x1, y1, x3, y3, instruction);
                break;
            }
            case 6: {
                opHandlers.h(instruction);
                break;
            }
            case 7: {
                double height = opStack.popNumber().doubleValue();
                double width = opStack.popNumber().doubleValue();
                double y1 = opStack.popNumber().doubleValue();
                double x = opStack.popNumber().doubleValue();
                opHandlers.re(x, y1, width, height, instruction);
                break;
            }
        }
    }
}

