/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.TIFFEngine;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TIFFOutputStream
extends FilterOutputStream {
    private TIFFEngine tiff;

    public TIFFOutputStream(OutputStream out, FilterParams p) {
        super(out);
        this.tiff = new TIFFEngine(out, p);
    }

    public TIFFOutputStream(OutputStream out) {
        this(out, null);
    }

    @Override
    public void write(int b) throws IOException {
        this.tiff.put(b & 0xFF);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int maxWrite = b.length - off;
        if (maxWrite > len) {
            maxWrite = len;
        }
        if (this.tiff.getBitsPerComponent() == 16) {
            while (maxWrite > 0) {
                int channel = 0;
                short newChar = (short)(b[off++] & 0xFF);
                channel = (short)(channel | newChar << 8);
                newChar = (short)(b[off++] & 0xFF);
                channel = (short)(channel | newChar);
                this.tiff.put(channel);
                maxWrite -= 2;
            }
        } else {
            while (maxWrite-- > 0) {
                this.write(b[off++] & 0xFF);
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public long getTotalOut() {
        return this.tiff.getTotalOut();
    }
}

