/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.DecodeInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.LZWEngine;
import java.io.InputStream;

public class LZWInputStream
extends DecodeInputStream {
    private LZWEngine lzw;

    public LZWInputStream(InputStream in, int inSize, int outSize, FilterParams diparams) {
        super(in, inSize, outSize, 0, diparams);
        this.lzw = new LZWEngine(in);
        if (diparams.containsKey("EarlyChange")) {
            this.lzw.setEarlyChange((Integer)diparams.get("EarlyChange"));
        }
    }

    public LZWInputStream(InputStream in, FilterParams p) {
        super(in, 0, p);
        this.lzw = new LZWEngine(this);
        if (this.diparams.containsKey("EarlyChange")) {
            this.lzw.setEarlyChange((Integer)this.diparams.get("EarlyChange"));
        }
    }

    public LZWInputStream(InputStream in) {
        this(in, null);
    }

    int read1() {
        if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
            return -1;
        }
        return this.inBuf[this.inPos++] & 0xFF;
    }

    int read2() {
        if (this.inCount - this.inPos >= 2) {
            this.inPos += 2;
            return ((this.inBuf[this.inPos - 2] & 0xFF) << 8) + (this.inBuf[this.inPos - 1] & 0xFF);
        }
        return -1;
    }

    int read3() {
        if (this.inCount - this.inPos >= 3) {
            this.inPos += 3;
            return ((this.inBuf[this.inPos - 3] & 0xFF) << 16) + ((this.inBuf[this.inPos - 2] & 0xFF) << 8) + (this.inBuf[this.inPos - 1] & 0xFF);
        }
        return -1;
    }

    @Override
    public void fill() {
        while (this.outCount < this.outBuf.length && !this.pendingEOF && this.pendingException == null) {
            int count = this.lzw.get(this.outBuf, this.outCount, this.outBuf.length - this.outCount);
            this.outCount += count;
            if (count != 0) continue;
            this.pendingEOF = true;
            break;
        }
    }

    @Override
    public int getInPos() {
        if (this.in instanceof DecodeInputStream) {
            return ((DecodeInputStream)this.in).getInPos();
        }
        return this.inTotal + this.inPos - this.lzw.getResidualBits() / 8;
    }
}

