/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomDecodeFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomEncodeFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilterException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CustomFilterRegistry {
    private HashMap<ASName, CustomDecodeFilter> decodeFilters = new HashMap();
    private HashMap<ASName, CustomEncodeFilter> encodeFilters = new HashMap();

    public void registerFilter(CustomFilter customFilter) {
        if (customFilter instanceof CustomEncodeFilter) {
            this.registerEncodeFilter((CustomEncodeFilter)customFilter);
        }
        if (customFilter instanceof CustomDecodeFilter) {
            this.registerDecodeFilter((CustomDecodeFilter)customFilter);
        }
    }

    protected void unregister(CustomFilter filter) {
        if (this.decodeFilters != null && this.decodeFilters.containsKey(filter.getName())) {
            this.decodeFilters.remove(filter.getName());
        }
        if (this.encodeFilters != null && this.encodeFilters.containsKey(filter.getName())) {
            this.encodeFilters.remove(filter.getName());
        }
    }

    public boolean isEncodeFilterRegistered(ASName filterName) {
        return this.encodeFilters != null && this.encodeFilters.containsKey(filterName);
    }

    public boolean isDecodeFilterRegistered(ASName filterName) {
        return this.decodeFilters != null && this.decodeFilters.containsKey(filterName);
    }

    public Collection<CustomEncodeFilter> getEncodeFilters() {
        return this.encodeFilters.values();
    }

    public Collection<CustomDecodeFilter> getDecodeFilters() {
        return this.decodeFilters.values();
    }

    public void registerEncodeFilter(CustomEncodeFilter filter) {
        this.encodeFilters.put(filter.getName(), filter);
    }

    public void registerDecodeFilter(CustomDecodeFilter filter) {
        this.decodeFilters.put(filter.getName(), filter);
    }

    protected InputStream decode(ASName filterName, InputStream inStm, FilterParams params) throws CustomFilterException {
        InputStream decodedStream = null;
        CustomDecodeFilter filterToUse = this.decodeFilters.get(filterName);
        if (filterToUse != null) {
            decodedStream = filterToUse.decode(inStm, params);
        }
        return decodedStream;
    }

    public OutputStream encode(ASName filterName, OutputStream dstStm, FilterParams params) throws CustomFilterException {
        OutputStream encodedStream = null;
        CustomEncodeFilter filterToUse = this.encodeFilters.get(filterName);
        if (filterToUse != null) {
            encodedStream = filterToUse.encode(dstStm, params);
        }
        return encodedStream;
    }

    protected FilterParams updateFilterParams(ASName filterName, FilterParams params) {
        FilterParams newParams = params;
        CustomEncodeFilter filterToUse = this.encodeFilters.get(filterName);
        if (filterToUse != null) {
            newParams = filterToUse.updateFilterParams(params);
        }
        return newParams;
    }

    public List getRegisteredFilters() {
        ArrayList<CustomFilter> customFilterList = new ArrayList<CustomFilter>();
        Collection<CustomDecodeFilter> decodeFilterList = this.getDecodeFilters();
        Collection<CustomEncodeFilter> encodeFilterList = this.getEncodeFilters();
        if (decodeFilterList != null) {
            customFilterList.addAll(decodeFilterList);
        }
        if (encodeFilterList != null) {
            customFilterList.addAll(encodeFilterList);
        }
        return customFilterList;
    }

    public static List getDefaultDecodeFilters() {
        return Arrays.asList(ASName.k_FlateDecode, ASName.k_Fl, ASName.k_ASCII85Decode, ASName.k_A85, ASName.k_ASCIIHexDecode, ASName.k_AHx, ASName.k_LZWDecode, ASName.k_LZW, ASName.k_Crypt, ASName.k_CCITTFaxDecode, ASName.k_CCF, ASName.k_DCTDecode, ASName.k_DCT, ASName.k_RunLengthDecode, ASName.k_RL);
    }

    public static List getDefaultEncodeFilters() {
        return Arrays.asList(ASName.k_FlateDecode, ASName.k_ASCII85Decode, ASName.k_ASCIIHexDecode, ASName.k_LZWDecode, ASName.k_RunLengthDecode, ASName.k_Crypt);
    }

    public CustomDecodeFilter getRegisteredDecodeFilterByName(ASName filterName) {
        return this.decodeFilters.get(filterName);
    }

    public CustomEncodeFilter getRegisteredEncodeFilterByName(ASName filterName) {
        return this.encodeFilters.get(filterName);
    }
}

