/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption.impl;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCECredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.encryption.impl.CMSEnvelopedDataDecryptor;
import com.adobe.internal.pdftoolkit.core.encryption.impl.CMSEnvelopedDataEncryptor;
import com.adobe.internal.pdftoolkit.core.encryption.impl.PKCS7Utils;
import com.adobe.internal.pdftoolkit.core.securityframework.CryptoMode;
import com.adobe.internal.pdftoolkit.core.securityframework.PKCS7EnvelopedDataHandler;
import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.EnvelopedData;
import com.rsa.certj.pkcs7.RecipientInfo;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import java.util.Date;
import java.util.Map;

public class PKCS7EnvelopedDataRSANonFIPSHandler
implements PKCS7EnvelopedDataHandler {
    @Override
    public byte[] buildPKCS7EnvelopedData(Credentials[] credentials, byte[] envelopedData, Map encryptParams) throws Exception {
        int certInd;
        Data data = (Data)ContentInfo.getInstance((int)1, null, null);
        data.setContent(envelopedData, 0, envelopedData.length);
        RSACredentials[] rsaCredentials = null;
        try {
            rsaCredentials = RSACredentials.newInstance(credentials);
        }
        catch (Exception exception) {
            throw new Exception("Unknown or invalid signature algorithm." + exception);
        }
        X509Certificate[] rsaCertificates = new X509Certificate[rsaCredentials.length];
        for (certInd = 0; certInd < rsaCredentials.length; ++certInd) {
            rsaCertificates[certInd] = rsaCredentials[certInd].getRSAX509Cert();
        }
        String[] algorithms = null;
        if (rsaCredentials != null && rsaCredentials.length > 0) {
            algorithms = rsaCredentials[0].getRSAX509Cert().getSignatureAlgorithm().split("/");
        }
        CertJ certJ = PKCS7Utils.createCertJContext(rsaCredentials, CryptoMode.NON_FIPS_MODE);
        CertPathCtx pathCtx = PKCS7EnvelopedDataRSANonFIPSHandler.buildDefaultCertPath(certJ, (Certificate[])rsaCertificates);
        if (algorithms[1].equalsIgnoreCase("ECDSA")) {
            try {
                CMSEnvelopedDataEncryptor cmsEnvelopedDataEncryptor = new CMSEnvelopedDataEncryptor();
                return cmsEnvelopedDataEncryptor.encryptEnvelopedData(rsaCredentials, rsaCertificates, envelopedData, algorithms, encryptParams);
            }
            catch (Exception cmsEnvelopedDataEncryptor) {}
        } else {
            EnvelopedData pkcs7 = (EnvelopedData)ContentInfo.getInstance((int)3, (CertJ)certJ, (CertPathCtx)pathCtx);
            for (certInd = 0; certInd < credentials.length; ++certInd) {
                RecipientInfo recipient = new RecipientInfo();
                X500Name issuer = rsaCertificates[certInd].getIssuerName();
                byte[] serialNumber = rsaCertificates[certInd].getSerialNumber();
                recipient.setIssuerAndSerialNumber(issuer, serialNumber, 0, serialNumber.length);
                recipient.setEncryptionAlgorithm("RSA");
                pkcs7.addRecipientInfo(recipient);
            }
            pkcs7.setEncryptionAlgorithm("3DES_EDE/CBC/PKCS5Padding", 128);
            pkcs7.setContentInfo((ContentInfo)data);
            byte[] pkcs7Array = new byte[pkcs7.getContentInfoDERLen()];
            pkcs7.writeMessage(pkcs7Array, 0);
            return pkcs7Array;
        }
        return null;
    }

    @Override
    public byte[] getEnvelopeData(Credentials recipient, byte[] pkcs7data) throws Exception {
        if (recipient == null) {
            return null;
        }
        try {
            CMSEnvelopedDataDecryptor dataDecryptor = new CMSEnvelopedDataDecryptor();
            if (recipient instanceof JCECredentials) {
                recipient = RSACredentials.newInstance(recipient);
            }
            JSAFE_PrivateKey privateKey = ((RSACredentials)recipient).getJSAFEPrivateKey();
            return dataDecryptor.getCMSEnvelopeData(privateKey, pkcs7data);
        }
        catch (Exception dataDecryptor) {
            Credentials[] recipients = new Credentials[]{recipient};
            CertJ certJ = PKCS7Utils.createCertJContext(RSACredentials.newInstance(recipients), CryptoMode.NON_FIPS_MODE);
            Certificate[] rsaCertChain = null;
            if (recipient instanceof JCECredentials) {
                rsaCertChain = RSACredentials.buildRSACertChain(((JCECredentials)recipient).getCertificateChain());
            } else if (recipient instanceof RSACredentials) {
                rsaCertChain = ((RSACredentials)recipient).getRSAX509CertChain();
            } else {
                throw new RuntimeException("Unsupported Credential Type: " + recipient.getClass());
            }
            CertPathCtx certPathCtx = PKCS7EnvelopedDataRSANonFIPSHandler.buildDefaultCertPath(certJ, rsaCertChain);
            EnvelopedData pkcs7 = (EnvelopedData)ContentInfo.getInstance((int)3, (CertJ)certJ, (CertPathCtx)certPathCtx);
            if (pkcs7.readInit(pkcs7data, 0, pkcs7data.length) && !pkcs7.readFinal()) {
                return null;
            }
            ContentInfo data = pkcs7.getContent();
            if (data.getContentType() == 1) {
                return ((Data)data).getData();
            }
            return null;
        }
    }

    private static CertPathCtx buildDefaultCertPath(CertJ certJ, Certificate[] rsaCertChain) throws InvalidParameterException, ProviderManagementException {
        DatabaseService dbService = (DatabaseService)certJ.bindServices(1);
        CertPathCtx certPathCtx = new CertPathCtx(4, rsaCertChain, (byte[][])null, new Date(), dbService);
        return certPathCtx;
    }
}

