/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.credentials.impl;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCECredentials;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class RSACredentials
implements Credentials {
    protected com.rsa.certj.cert.X509Certificate rsaX509Cert;
    protected Certificate[] rsaX509CertChain;
    protected JSAFE_PrivateKey JSAFEPrivateKey;
    protected PrivateKey privateKey;

    public RSACredentials(JSAFE_PrivateKey jsafePrivateKey, com.rsa.certj.cert.X509Certificate cert, Certificate[] certChain) {
        this.JSAFEPrivateKey = jsafePrivateKey;
        this.rsaX509Cert = cert;
        this.rsaX509CertChain = certChain;
    }

    public RSACredentials(PrivateKey privateKey, com.rsa.certj.cert.X509Certificate cert, Certificate[] certChain) throws JSAFE_UnimplementedException {
        this.JSAFEPrivateKey = RSACredentials.getRSAPrivateKey(privateKey);
        this.rsaX509Cert = cert;
        this.rsaX509CertChain = certChain;
        this.privateKey = privateKey;
    }

    public static RSACredentials newInstance(Credentials credentials) throws JSAFE_UnimplementedException, CertificateEncodingException, CertificateException {
        if (credentials instanceof RSACredentials) {
            return (RSACredentials)credentials;
        }
        if (credentials instanceof JCECredentials && !credentials.isHSM()) {
            JCECredentials jceCred = (JCECredentials)credentials;
            PrivateKey privateKey = jceCred.getPrivateKey();
            return new RSACredentials(privateKey, RSACredentials.getRSACert(jceCred.getCertificate()), RSACredentials.buildRSACertChain(jceCred.getCertificateChain()));
        }
        throw new RuntimeException("Unsupported Credential type: " + credentials.getClass());
    }

    public static RSACredentials[] newInstance(Credentials[] credentials) throws JSAFE_UnimplementedException, CertificateEncodingException, CertificateException {
        RSACredentials[] rsaCredentials = new RSACredentials[credentials.length];
        for (int credInd = 0; credInd < credentials.length; ++credInd) {
            rsaCredentials[credInd] = RSACredentials.newInstance(credentials[credInd]);
        }
        return rsaCredentials;
    }

    static JSAFE_PrivateKey getRSAPrivateKey(PrivateKey privateKey) throws JSAFE_UnimplementedException {
        if (privateKey != null) {
            return JSAFE_PrivateKey.getInstance((byte[])privateKey.getEncoded(), (int)0, (String)"Java");
        }
        return null;
    }

    public static com.rsa.certj.cert.X509Certificate getRSACert(X509Certificate cert) throws CertificateEncodingException, CertificateException {
        if (cert != null) {
            return new com.rsa.certj.cert.X509Certificate(cert.getEncoded(), 0, 0);
        }
        return null;
    }

    public com.rsa.certj.cert.X509Certificate getRSAX509Cert() {
        return this.rsaX509Cert;
    }

    public JSAFE_PrivateKey getJSAFEPrivateKey() {
        return this.JSAFEPrivateKey;
    }

    public Certificate[] getRSAX509CertChain() {
        return this.rsaX509CertChain;
    }

    public static Certificate[] buildRSACertChain(java.security.cert.Certificate[] certChain) throws CertificateEncodingException, CertificateException {
        if (certChain != null) {
            Certificate[] rsaCertChain = new Certificate[certChain.length];
            for (int i = 0; i < certChain.length; ++i) {
                X509Certificate javaCert = (X509Certificate)certChain[i];
                com.rsa.certj.cert.X509Certificate rsaCert = new com.rsa.certj.cert.X509Certificate(javaCert.getEncoded(), 0, 0);
                rsaCertChain[i] = rsaCert;
            }
            return rsaCertChain;
        }
        return null;
    }

    @Override
    public boolean isHSM() {
        return false;
    }
}

