/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import java.io.IOException;
import java.io.InputStream;

public class ChainedInputStream
extends InputStream {
    private InputStream[] streams;
    private int streamIndex;
    private int streamCount;
    private static final int EOF = -1;

    public ChainedInputStream(InputStream[] streams) {
        this.streams = streams;
        this.streamCount = streams.length;
    }

    public int read() throws IOException {
        if (this.streamIndex >= this.streamCount) {
            return -1;
        }
        int value = this.streams[this.streamIndex].read();
        while (value == -1 && ++this.streamIndex < this.streamCount) {
            value = this.streams[this.streamIndex].read();
        }
        return value;
    }

    public int available() throws IOException {
        if (this.streamIndex >= this.streamCount) {
            return 0;
        }
        return this.streams[this.streamIndex].available();
    }

    public void close() throws IOException {
        for (int i = 0; i < this.streamCount; ++i) {
            this.streams[i].close();
        }
        this.streams = null;
        this.streamCount = 0;
    }
}

