/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.pdffont;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.CatalogDescription;
import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.postscript.GlyphNamesAccessor;
import com.adobe.fontengine.font.postscript.ScriptHeuristics;
import com.adobe.fontengine.font.postscript.UnicodeCmap;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.PDFSimpleFontValuesAccessor;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public final class PDFSimpleFont
extends FontData {
    private final String fontFamily;
    private final String postscriptName;
    private final Rect fontBBox;
    private final double capHeight;
    private final double xHeight;
    private final double ascent;
    private final double descent;
    private final double leading;
    private final double stemV;
    private final double italicAngle;
    private final int flags;
    private final int weight;
    private final CSS20Attribute.CSSStretchValue stretch;
    private final int numGlyphs;
    private final UnicodeCmap cmap;
    private final double[] gid2width;
    private final String[] gid2name;

    public PDFSimpleFont(PDFSimpleFontValuesAccessor dataAccessor) throws InvalidFontException, UnsupportedFontException {
        super(null);
        this.fontFamily = dataAccessor.getFontFamily();
        this.postscriptName = dataAccessor.getPostscriptName();
        this.fontBBox = dataAccessor.getFontBBox();
        this.capHeight = dataAccessor.getCapHeight();
        this.ascent = dataAccessor.getAscent();
        this.descent = dataAccessor.getDescent();
        this.leading = dataAccessor.getLeading();
        this.stemV = dataAccessor.getStemV();
        this.italicAngle = dataAccessor.getItalicAngle();
        this.flags = dataAccessor.getFlags();
        this.weight = dataAccessor.getFontWeight();
        this.stretch = dataAccessor.getFontStretch();
        this.xHeight = dataAccessor.getXHeight();
        int[] gid2characterCode = new int[257];
        this.gid2name = new String[257];
        int lastGid = 0;
        gid2characterCode[0] = 0;
        this.gid2name[0] = ".notdef";
        for (int characterCode = 0; characterCode < 256; ++characterCode) {
            String name = dataAccessor.getGlyphName(characterCode);
            if (name == null) continue;
            gid2characterCode[++lastGid] = characterCode;
            this.gid2name[lastGid] = name;
        }
        this.numGlyphs = lastGid + 1;
        this.cmap = UnicodeCmap.computeCmapFromGlyphNames(this.numGlyphs, false, new GlyphNamesAccessor(){

            @Override
            public String getAGlyphName(int gid) throws InvalidFontException, UnsupportedFontException {
                return PDFSimpleFont.this.gid2name[gid];
            }
        });
        this.gid2width = new double[this.numGlyphs];
        for (int gid = 0; gid < this.numGlyphs; ++gid) {
            this.gid2width[gid] = dataAccessor.getGlyphWidth(gid2characterCode[gid]);
        }
    }

    @Override
    public boolean getCoolTypeProportionalRomanFromFontProperties() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException {
        return (this.flags & 4) != 0;
    }

    @Override
    public int getNumGlyphs() throws InvalidFontException, UnsupportedFontException {
        return this.numGlyphs;
    }

    @Override
    public double getUnitsPerEmX() throws UnsupportedFontException, InvalidFontException {
        return 1000.0;
    }

    @Override
    public double getUnitsPerEmY() throws UnsupportedFontException, InvalidFontException {
        return 1000.0;
    }

    @Override
    protected Rect getCoolTypeRawFontBBox() throws InvalidFontException, UnsupportedFontException {
        return this.fontBBox;
    }

    @Override
    public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
        return this.fontBBox;
    }

    @Override
    public CoolTypeScript getCoolTypeScript() throws UnsupportedFontException, InvalidFontException {
        return ScriptHeuristics.getCoolTypeScript(this.postscriptName, this.getNumGlyphs(), new GlyphNamesAccessor(){

            @Override
            public String getAGlyphName(int gid) throws InvalidFontException, UnsupportedFontException {
                return PDFSimpleFont.this.gid2name[gid];
            }
        });
    }

    private Rect getCoolTypeIdeoEmBoxFromCapHeight() throws InvalidFontException, UnsupportedFontException {
        if (Double.isNaN(this.capHeight)) {
            return null;
        }
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        double ymin = -(unitsPerEmY - this.capHeight) / 2.0;
        return new Rect(0.0, ymin, unitsPerEmX, ymin + unitsPerEmY);
    }

    @Override
    public Rect getCoolTypeIdeoEmBox() throws UnsupportedFontException, InvalidFontException {
        Rect r = this.getCoolTypeIdeoEmBoxFromCapHeight();
        if (r != null) {
            return r;
        }
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        return new Rect(0.0, -0.12 * unitsPerEmY, unitsPerEmX, 0.88 * unitsPerEmY);
    }

    @Override
    public Rect getCoolTypeIcfBox() throws InvalidFontException, UnsupportedFontException {
        return this.getCoolTypeIcfBoxFromIdeoEmBox(this.getCoolTypeIdeoEmBox());
    }

    @Override
    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException {
        return new LineMetrics(this.ascent, this.descent, this.leading);
    }

    @Override
    public UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException {
        return new UnderlineMetrics(-150.0, 50.0);
    }

    @Override
    public int getGlyphForChar(int unicodeScalarValue) throws InvalidFontException, UnsupportedFontException {
        return this.cmap.getGlyphForChar(unicodeScalarValue);
    }

    @Override
    public Rect getGlyphBBox(int gid) throws UnsupportedFontException, InvalidFontException {
        return this.fontBBox;
    }

    @Override
    public void getGlyphOutline(int gid, OutlineConsumer consumer) throws InvalidFontException, UnsupportedFontException {
        throw new UnsupportedFontException("cannot get outline for PDFSimpleFont");
    }

    @Override
    public double getHorizontalAdvance(int gid) throws InvalidGlyphException, UnsupportedFontException, InvalidFontException {
        return this.gid2width[gid];
    }

    @Override
    public Scaler getScaler(ScanConverter c) throws InvalidFontException, UnsupportedFontException {
        throw new UnsupportedFontException("getOutlineAccessor not supported for PDFSimpleFont");
    }

    @Override
    public Permission getEmbeddingPermission(boolean wasEmbedded) throws InvalidFontException, UnsupportedFontException {
        return Permission.RESTRICTED;
    }

    @Override
    public PDFFontDescription getPDFFontDescription(Font font) {
        return new PDFSimpleFontXDCFontDescription();
    }

    @Override
    public XDCFontDescription getXDCFontDescription(Font font) {
        return new PDFSimpleFontXDCFontDescription();
    }

    @Override
    public Subset createSubset() throws InvalidFontException, UnsupportedFontException {
        throw new UnsupportedFontException("createSubset not meaningful for PDFSimpleFont");
    }

    @Override
    public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS) throws InvalidFontException, UnsupportedFontException, IOException {
        throw new UnsupportedFontException("subsetAndStream not meaningful for PDFSimpleFont");
    }

    @Override
    public CacheSupportInfo getCacheSupportInfo() throws InvalidFontException, UnsupportedFontException {
        return new CacheSupportInfo(this.getClass().getSimpleName(), this.getNumGlyphs(), false);
    }

    @Override
    public PostscriptFontDescription[] getPostscriptFontDescription() throws InvalidFontException, UnsupportedFontException {
        return new PostscriptFontDescription[]{new PostscriptFontDescription(this.postscriptName)};
    }

    @Override
    protected Set getCSSFamilyNames() throws InvalidFontException, UnsupportedFontException {
        HashSet<String> s = new HashSet<String>();
        if (this.fontFamily != null) {
            s.add(this.fontFamily);
        }
        return s;
    }

    @Override
    protected String getPreferredCSSFamilyName() throws InvalidFontException, UnsupportedFontException {
        return this.fontFamily;
    }

    @Override
    protected CSS20Attribute.CSSStretchValue getCSSStretchValue() throws InvalidFontException, UnsupportedFontException {
        return this.stretch;
    }

    @Override
    protected int getCSSWeight() throws InvalidFontException, UnsupportedFontException {
        return this.weight;
    }

    @Override
    protected boolean isCSSStyleItalic() throws InvalidFontException, UnsupportedFontException {
        return this.italicAngle != 0.0 || (this.flags & 0x40) != 0;
    }

    @Override
    protected boolean isCSSStyleNormal() throws InvalidFontException, UnsupportedFontException {
        return !this.isCSSStyleItalic();
    }

    @Override
    protected boolean isCSSStyleOblique() throws InvalidFontException, UnsupportedFontException {
        return false;
    }

    @Override
    protected boolean isCSSVariantNormal() throws InvalidFontException, UnsupportedFontException {
        return !this.isCSSVariantSmallCaps();
    }

    @Override
    protected boolean isCSSVariantSmallCaps() throws InvalidFontException, UnsupportedFontException {
        return (this.flags & 0x20000) != 0;
    }

    @Override
    public FXGFontDescription[] getFXGFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException {
        return new FXGFontDescription[0];
    }

    @Override
    public PlatformFontDescription[] getPlatformFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException {
        return new PlatformFontDescription[0];
    }

    @Override
    public CatalogDescription getSelectionDescription() throws InvalidFontException, UnsupportedFontException {
        throw new UnsupportedFontException("getSelectionDescription not supported for PDFSimpleFont");
    }

    @Override
    public SWFFontDescription getSWFFontDescription(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
        return null;
    }

    @Override
    public SWFFont4Description getSWFFont4Description(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
        return null;
    }

    class PDFSimpleFontXDCFontDescription
    extends XDCFontDescription {
        PDFSimpleFontXDCFontDescription() {
        }

        @Override
        public double getAdvance(int gid) throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.gid2width[gid];
        }

        @Override
        public String getBase14Name() {
            return null;
        }

        @Override
        public double getCapHeight() throws UnsupportedFontException, InvalidFontException {
            return PDFSimpleFont.this.capHeight;
        }

        @Override
        public double getXHeight() throws UnsupportedFontException, InvalidFontException {
            return PDFSimpleFont.this.xHeight;
        }

        @Override
        public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.fontBBox;
        }

        @Override
        public String getFontFamily() throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.fontFamily;
        }

        @Override
        public int getGlyphCid(int gid) throws UnsupportedFontException, InvalidFontException {
            return -1;
        }

        @Override
        public String getGlyphName(int gid) throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.gid2name[gid];
        }

        @Override
        public double getItalicAngle() throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.italicAngle;
        }

        @Override
        public int getNumGlyphs() throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.numGlyphs;
        }

        @Override
        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            return PDFSimpleFont.this.postscriptName;
        }

        @Override
        public ROS getROS() throws UnsupportedFontException, InvalidFontException {
            return null;
        }

        @Override
        public double getStemV() throws UnsupportedFontException, InvalidFontException {
            return PDFSimpleFont.this.stemV;
        }

        @Override
        public boolean pdfFontIsTrueType() throws InvalidFontException, UnsupportedFontException {
            return false;
        }

        @Override
        public boolean isSerifFont() {
            return (PDFSimpleFont.this.flags & 2) != 0;
        }

        @Override
        public boolean isSmallCapFont() {
            return (PDFSimpleFont.this.flags & 0x20000) != 0;
        }

        @Override
        public boolean isAllCapFont() throws InvalidFontException, UnsupportedFontException {
            return (PDFSimpleFont.this.flags & 0x10000) != 0;
        }

        @Override
        public int getCIDCount() {
            return -1;
        }

        @Override
        public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS) throws UnsupportedFontException {
            throw new UnsupportedFontException("subsetAndStream not meaningful for PDFSimpleFont");
        }

        @Override
        public void subsetAndStream(SubsetSimpleType1 t1Subset, OutputStream out) throws UnsupportedFontException {
            throw new UnsupportedFontException("subsetAndStream not meaningful for PDFSimpleFont");
        }

        @Override
        public void subsetAndStream(SubsetSimpleTrueType ttSubset, OutputStream out) throws UnsupportedFontException {
            throw new UnsupportedFontException("subsetAndStream not meaningful for PDFSimpleFont");
        }

        @Override
        public CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException {
            if (PDFSimpleFont.this.isSymbolic()) {
                return new CodePage[0];
            }
            CodePage theCodePage = null;
            for (int i = 0; i < PDFSimpleFont.this.numGlyphs; ++i) {
                if (PDFSimpleFont.this.gid2name[i].equals("ecircumflex")) {
                    if (theCodePage == CodePage.ROMAN2) {
                        return new CodePage[0];
                    }
                    theCodePage = CodePage.ROMAN1;
                    continue;
                }
                if (!PDFSimpleFont.this.gid2name[i].equals("Ccaron") && !PDFSimpleFont.this.gid2name[i].equals("ncaron")) continue;
                if (theCodePage == CodePage.ROMAN1) {
                    return new CodePage[0];
                }
                theCodePage = CodePage.ROMAN2;
            }
            if (theCodePage == null) {
                return new CodePage[0];
            }
            CodePage[] retVal = new CodePage[]{theCodePage};
            return retVal;
        }

        @Override
        public void stream(OutputStream out, boolean openTypeFontsAllowed) throws UnsupportedFontException {
            throw new UnsupportedFontException("stream not meaningful for PDFSimpleFont");
        }
    }
}

