/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import java.io.IOException;
import java.io.OutputStream;

public final class OTByteArray
extends FontByteArray {
    private OTByteArray(int size) {
        super(size);
    }

    OTByteArray(FontByteArray array) throws IOException, InvalidFontException, UnsupportedFontException {
        super(array, false);
    }

    private OTByteArray(OTByteArray original) {
        super(original, true);
    }

    public static final OTByteArrayBuilder getOTByteArrayBuilderInstance() {
        return new OTByteArrayBuilder();
    }

    static final OTByteArrayBuilder getOTByteArrayBuilderInstance(int size) {
        return new OTByteArrayBuilder(size);
    }

    static final OTByteArrayBuilder getOTByteArrayBuilderInstance(OTByteArray original) {
        return new OTByteArrayBuilder(original);
    }

    public final int getuint8(int offset) throws InvalidFontException {
        return this.getRawByte(offset) & 0xFF;
    }

    protected final int getint8(int offset) throws InvalidFontException {
        return this.getSignedRawByte(offset);
    }

    protected final int getuint16(int offset) throws InvalidFontException {
        return this.getuint8(offset) << 8 | this.getuint8(offset + 1);
    }

    public final int getint16(int offset) throws InvalidFontException {
        return this.getint8(offset) << 8 | this.getuint8(offset + 1);
    }

    protected final int getint32(int offset) throws InvalidFontException {
        return this.getint8(offset) << 24 | this.getuint8(offset + 1) << 16 | this.getuint8(offset + 2) << 8 | this.getuint8(offset + 3);
    }

    protected final long getuint32(int offset) throws InvalidFontException {
        return (long)this.getuint8(offset) << 24 | (long)(this.getuint8(offset + 1) << 16) | (long)(this.getuint8(offset + 2) << 8) | (long)this.getuint8(offset + 3);
    }

    protected final int getuint24(int offset) throws InvalidFontException {
        return this.getuint8(offset) << 16 | this.getuint8(offset + 1) << 8 | this.getuint8(offset + 2);
    }

    protected final int getuint32asint(int offset, String exceptionMsg) throws UnsupportedFontException, InvalidFontException {
        if (this.getuint8(offset) > 127) {
            throw new UnsupportedFontException(exceptionMsg);
        }
        return (int)this.getuint32(offset);
    }

    protected final int[] getFixed(int offset) throws InvalidFontException {
        int[] result = new int[]{this.getuint16(offset), this.getuint16(offset + 2)};
        return result;
    }

    protected final long getLONGDATETIME(int offset) throws InvalidFontException {
        return this.getuint32(offset) << 32 | this.getuint32(offset);
    }

    protected final int getOffset(int base, int offset) throws InvalidFontException {
        int o = this.getuint16(base + offset);
        if (o != 0) {
            return base + o;
        }
        return 0;
    }

    protected long checksum() throws InvalidFontException {
        return this.checksum(0, this.getSize(), 0L);
    }

    protected long checksum(int from, int to, long checksum) throws InvalidFontException {
        while (from < to) {
            int b1 = this.getuint8(from++);
            int b2 = 0;
            if (from < to) {
                b2 = this.getuint8(from++);
            }
            int b3 = 0;
            if (from < to) {
                b3 = this.getuint8(from++);
            }
            int b4 = 0;
            if (from < to) {
                b4 = this.getuint8(from++);
            }
            int word = b1 << 24 | b2 << 16 | b3 << 8 | b4;
            checksum = checksum + (long)word & 0xFFFFFFFFL;
        }
        return checksum;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OTByteArray)) {
            return false;
        }
        return super.equals(other);
    }

    static final class OTByteArrayBuilder
    extends FontByteArray.FontByteArrayBuilder {
        protected OTByteArrayBuilder() {
            super(new OTByteArray(1024));
        }

        protected OTByteArrayBuilder(int size) {
            super(new OTByteArray(size));
        }

        protected OTByteArrayBuilder(OTByteArray original) {
            super(new OTByteArray(original));
        }

        final void setuint8(int offset, int value) {
            this.setRawByte(offset, value & 0xFF);
        }

        final void setuint16(int offset, int value) {
            this.setRawByte(offset, value >> 8 & 0xFF);
            this.setRawByte(++offset, value & 0xFF);
        }

        final int getuint16(int offset) {
            int i = this.getRawByte(offset) & 0xFF;
            i <<= 8;
            return i |= this.getRawByte(offset + 1) & 0xFF;
        }

        final void setint16(int offset, int value) {
            this.setuint16(offset, value);
        }

        final void setuint24(int offset, int value) {
            this.setRawByte(offset, value >> 16 & 0xFF);
            this.setRawByte(++offset, value >> 8 & 0xFF);
            this.setRawByte(++offset, value & 0xFF);
        }

        final void setuint32(int offset, int value) {
            this.setRawByte(offset, value >> 24 & 0xFF);
            this.setRawByte(++offset, value >> 16 & 0xFF);
            this.setRawByte(++offset, value >> 8 & 0xFF);
            this.setRawByte(++offset, value & 0xFF);
        }

        final void setFixed(int offset, int major, int minor) throws InvalidFontException {
            this.setuint16(offset, major);
            this.setuint16(offset + 2, minor);
        }

        final long checksum(int from, int to, long checksum) throws InvalidFontException {
            return ((OTByteArray)this.byteArray).checksum();
        }

        OTByteArray toOTByteArray() {
            OTByteArray retvalue = (OTByteArray)this.byteArray;
            this.byteArray = null;
            return retvalue;
        }

        static class OTByteArrayBuilderOutputStreamAdaptor
        extends OutputStream {
            private OTByteArrayBuilder builder = new OTByteArrayBuilder();
            private int position = 0;

            OTByteArrayBuilderOutputStreamAdaptor() {
            }

            @Override
            public void write(int b) throws IOException {
                this.builder.ensureCapacity(this.position + 1);
                this.builder.setuint8(this.position, b);
                ++this.position;
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.builder.append(b, off, len);
                this.position += len;
            }

            OTByteArrayBuilder getBuilder() {
                return this.builder;
            }
        }
    }
}

