/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.OTByteArray;
import java.util.Arrays;

class LayoutTableSubsetter {
    protected final LayoutTable origTable;
    protected final OTByteArray.OTByteArrayBuilder builder;
    static int maxOffset = 65535;

    LayoutTableSubsetter(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder) {
        this.origTable = origTable;
        this.builder = builder;
    }

    protected int writeByteArrayAtOffset(int newOffset, OTByteArray byteArrayToWrite) throws InvalidFontException {
        this.builder.replace(newOffset, byteArrayToWrite, 0, byteArrayToWrite.getSize());
        return byteArrayToWrite.getSize();
    }

    protected int writeClassDef(int origSTOffset, int stOffsetDelta, int newSTOffset, int newSubtableSize, Subset subset, int origNumGlyphs) throws InvalidFontException, UnsupportedFontException {
        ClassDefGenerator generator = ClassDefGenerator.newInstance(this.origTable, this.origTable.data.getOffset(origSTOffset, stOffsetDelta), subset, origNumGlyphs);
        this.builder.setuint16(newSTOffset + stOffsetDelta, newSubtableSize);
        OTByteArray array = generator.generateClass().toOTByteArray();
        return this.writeByteArrayAtOffset(newSTOffset + newSubtableSize, array);
    }

    static class ClassCoveredBySubset
    implements LayoutTable.ClassConsumer {
        private final Subset subset;
        private boolean glyphFound;

        ClassCoveredBySubset(Subset subset) {
            this.subset = subset;
        }

        @Override
        public boolean glyph(int glyphID, int classID) throws UnsupportedFontException, InvalidFontException {
            if (this.subset.getExistingSubsetGid(glyphID) != -1) {
                this.glyphFound = true;
                return false;
            }
            return true;
        }

        boolean classCoveredBySubset(LayoutTable origTable, int origClassDefOffset, int numGlyphs, int theClass) throws UnsupportedFontException, InvalidFontException {
            this.glyphFound = false;
            origTable.iterateClass(origClassDefOffset, numGlyphs, this, theClass);
            return this.glyphFound;
        }
    }

    private static class CoverageFormat2Generator
    extends CoverageGenerator {
        private final int numRanges;
        private final boolean[] subsetGlyphInCoverage;

        public CoverageFormat2Generator(LayoutTable origTable, int origCoverageOffset, Subset subset, int numRanges, boolean[] subsetGlyphInCoverage) {
            super(origTable, origCoverageOffset, subset);
            this.numRanges = numRanges;
            this.newCoverage = OTByteArray.getOTByteArrayBuilderInstance(4 + 6 * numRanges);
            this.newCoverage.setuint16(0, 2);
            this.newCoverage.setuint16(2, numRanges);
            this.subsetGlyphInCoverage = subsetGlyphInCoverage;
        }

        private void writeRanges() {
            int currentRange = 0;
            if (this.subsetGlyphInCoverage[0]) {
                this.newCoverage.setuint16(4, 0);
                ++this.numGlyphsFound;
            } else {
                currentRange = -1;
            }
            for (int i = 1; i < this.subsetGlyphInCoverage.length; ++i) {
                if (this.subsetGlyphInCoverage[i]) {
                    ++this.numGlyphsFound;
                }
                if (!this.subsetGlyphInCoverage[i - 1] && this.subsetGlyphInCoverage[i]) {
                    this.newCoverage.setuint16(4 + 6 * ++currentRange, i);
                    continue;
                }
                if (!this.subsetGlyphInCoverage[i - 1] || this.subsetGlyphInCoverage[i]) continue;
                this.newCoverage.setuint16(4 + 6 * currentRange + 2, i - 1);
            }
            if (this.subsetGlyphInCoverage[this.subsetGlyphInCoverage.length - 1]) {
                this.newCoverage.setuint16(4 + 6 * currentRange + 2, this.subsetGlyphInCoverage.length - 1);
            }
        }

        @Override
        OTByteArray.OTByteArrayBuilder generateCoverage() throws InvalidFontException, UnsupportedFontException {
            this.writeRanges();
            if (this.numRanges != 0) {
                int currentCoverageIndex = 0;
                for (int i = 0; i < this.numRanges; ++i) {
                    int start = this.newCoverage.getuint16(4 + 6 * i);
                    int end = this.newCoverage.getuint16(4 + 6 * i + 2);
                    this.newCoverage.setuint16(4 + 6 * i + 4, currentCoverageIndex);
                    currentCoverageIndex += 1 + end - start;
                }
            }
            return this.newCoverage;
        }
    }

    private static class CoverageFormat1Generator
    extends CoverageGenerator {
        private final boolean[] subsetGlyphInCoverage;

        CoverageFormat1Generator(LayoutTable origTable, int origCoverageOffset, Subset subset, int numGids, boolean[] subsetGlyphInCoverage) {
            super(origTable, origCoverageOffset, subset);
            this.newCoverage = OTByteArray.getOTByteArrayBuilderInstance(4 + 2 * numGids);
            this.newCoverage.setuint16(0, 1);
            this.newCoverage.setuint16(2, numGids);
            this.subsetGlyphInCoverage = subsetGlyphInCoverage;
        }

        @Override
        OTByteArray.OTByteArrayBuilder generateCoverage() throws InvalidFontException, UnsupportedFontException {
            int j = 0;
            for (int i = 0; i < this.subsetGlyphInCoverage.length; ++i) {
                if (!this.subsetGlyphInCoverage[i]) continue;
                this.newCoverage.setuint16(4 + 2 * j, i);
                ++j;
            }
            this.numGlyphsFound = j;
            return this.newCoverage;
        }
    }

    static abstract class CoverageGenerator {
        OTByteArray.OTByteArrayBuilder newCoverage;
        protected final LayoutTable origTable;
        protected final int origCoverageOffset;
        protected final Subset subset;
        protected int numGlyphsFound = 0;

        CoverageGenerator(LayoutTable origTable, int origCoverageOffset, Subset subset) {
            this.origTable = origTable;
            this.origCoverageOffset = origCoverageOffset;
            this.subset = subset;
        }

        static CoverageGenerator newInstance(LayoutTable origTable, int origCoverageOffset, Subset subset) throws InvalidFontException, UnsupportedFontException {
            CoverageFormatDecider consumer = new CoverageFormatDecider(subset);
            origTable.iterateCoverage(origCoverageOffset, null, consumer);
            int nRanges = consumer.countRanges();
            int format1Size = 2 * consumer.numGids;
            int format2Size = 6 * nRanges;
            if (format1Size < format2Size) {
                return new CoverageFormat1Generator(origTable, origCoverageOffset, subset, consumer.numGids, consumer.subsetGlyphInCoverage);
            }
            return new CoverageFormat2Generator(origTable, origCoverageOffset, subset, nRanges, consumer.subsetGlyphInCoverage);
        }

        abstract OTByteArray.OTByteArrayBuilder generateCoverage() throws InvalidFontException, UnsupportedFontException;
    }

    static class ClassDef2Generator
    extends ClassDefGenerator {
        private final OTByteArray.OTByteArrayBuilder builder;
        private final int nRanges;

        ClassDef2Generator(int[] subsetClasses, int size) {
            super(subsetClasses);
            this.builder = OTByteArray.getOTByteArrayBuilderInstance(size);
            this.nRanges = (size - 4) / 6;
        }

        @Override
        OTByteArray.OTByteArrayBuilder generateClass() throws InvalidFontException, UnsupportedFontException {
            int i;
            this.builder.setuint16(0, 2);
            this.builder.setuint16(2, this.nRanges);
            int currentRange = 0;
            for (i = 0; i < this.subsetClasses.length && this.subsetClasses[i] == 0; ++i) {
            }
            if (i < this.subsetClasses.length) {
                this.builder.setuint16(4, i);
                this.builder.setuint16(8, this.subsetClasses[i]);
                ++currentRange;
            }
            ++i;
            while (i < this.subsetClasses.length) {
                while (i < this.subsetClasses.length && this.subsetClasses[i] == this.subsetClasses[i - 1]) {
                    ++i;
                }
                this.builder.setuint16(4 + 6 * (currentRange - 1) + 2, i - 1);
                while (i < this.subsetClasses.length && this.subsetClasses[i] == 0) {
                    ++i;
                }
                if (i < this.subsetClasses.length) {
                    this.builder.setuint16(4 + 6 * currentRange, i);
                    this.builder.setuint16(4 + 6 * currentRange + 4, this.subsetClasses[i]);
                    ++currentRange;
                }
                ++i;
            }
            return this.builder;
        }
    }

    static class ClassDef1Generator
    extends ClassDefGenerator {
        private final OTByteArray.OTByteArrayBuilder builder;

        ClassDef1Generator(int[] subsetClasses, int size) {
            super(subsetClasses);
            this.builder = OTByteArray.getOTByteArrayBuilderInstance(size);
        }

        @Override
        OTByteArray.OTByteArrayBuilder generateClass() throws InvalidFontException, UnsupportedFontException {
            int endGID;
            int startGID;
            for (startGID = 0; startGID < this.subsetClasses.length && this.subsetClasses[startGID] == 0; ++startGID) {
            }
            for (endGID = this.subsetClasses.length - 1; endGID >= 0 && this.subsetClasses[endGID] == 0; --endGID) {
            }
            this.builder.setuint16(0, 1);
            if (startGID <= endGID) {
                this.builder.setuint16(2, startGID);
                this.builder.setuint16(4, endGID - startGID + 1);
            } else {
                this.builder.setuint16(2, 0);
                this.builder.setuint16(4, 0);
            }
            for (int i = 0; i <= endGID - startGID; ++i) {
                this.builder.setuint16(6 + 2 * i, this.subsetClasses[startGID + i]);
            }
            return this.builder;
        }
    }

    static abstract class ClassDefGenerator {
        protected final int[] subsetClasses;

        ClassDefGenerator(int[] subsetClasses) {
            this.subsetClasses = subsetClasses;
        }

        static ClassDefGenerator newInstance(LayoutTable origTable, int origClassDefOffset, Subset subset, int numGlyphs) throws InvalidFontException, UnsupportedFontException {
            ClassFormatDecider consumer = new ClassFormatDecider(subset);
            origTable.iterateClass(origClassDefOffset, numGlyphs, consumer, -1);
            int format1Size = consumer.getFormat1Size();
            int format2Size = consumer.getFormat2Size();
            if (format1Size < format2Size) {
                return new ClassDef1Generator(consumer.subsetClasses, format1Size);
            }
            return new ClassDef2Generator(consumer.subsetClasses, format2Size);
        }

        abstract OTByteArray.OTByteArrayBuilder generateClass() throws InvalidFontException, UnsupportedFontException;
    }

    private static class ClassFormatDecider
    implements LayoutTable.ClassConsumer {
        private final Subset subset;
        int[] subsetClasses;

        ClassFormatDecider(Subset subset) {
            this.subset = subset;
            this.subsetClasses = new int[subset.getNumGlyphs()];
        }

        @Override
        public boolean glyph(int glyphID, int classID) throws UnsupportedFontException, InvalidFontException {
            int subsetGid = this.subset.getExistingSubsetGid(glyphID);
            if (subsetGid != -1) {
                this.subsetClasses[subsetGid] = classID;
            }
            return true;
        }

        int getFormat1Size() {
            int end;
            int start;
            for (start = 0; start < this.subsetClasses.length && this.subsetClasses[start] == 0; ++start) {
            }
            for (end = this.subsetClasses.length - 1; end > start && this.subsetClasses[end] == 0; --end) {
            }
            return 6 + 2 * (end - start + 1);
        }

        int getFormat2Size() {
            int i;
            int nRanges = 0;
            for (i = 0; i < this.subsetClasses.length && this.subsetClasses[i] == 0; ++i) {
            }
            if (i < this.subsetClasses.length) {
                ++nRanges;
            }
            ++i;
            while (i < this.subsetClasses.length) {
                while (i < this.subsetClasses.length && this.subsetClasses[i] == this.subsetClasses[i - 1]) {
                    ++i;
                }
                while (i < this.subsetClasses.length && this.subsetClasses[i] == 0) {
                    ++i;
                }
                if (i < this.subsetClasses.length) {
                    ++nRanges;
                }
                ++i;
            }
            return 4 + 6 * nRanges;
        }
    }

    private static class CoverageFormatDecider
    implements LayoutTable.CoverageConsumer {
        private final Subset subset;
        boolean[] subsetGlyphInCoverage;
        int numGids = 0;

        CoverageFormatDecider(Subset subset) {
            this.subset = subset;
            this.subsetGlyphInCoverage = new boolean[subset.getNumGlyphs()];
            Arrays.fill(this.subsetGlyphInCoverage, false);
        }

        @Override
        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            int subsetGid = this.subset.getExistingSubsetGid(gid);
            if (subsetGid != -1) {
                this.subsetGlyphInCoverage[subsetGid] = true;
                ++this.numGids;
            }
            return true;
        }

        int countRanges() {
            int nRanges = this.subsetGlyphInCoverage[0] ? 1 : 0;
            for (int i = 1; i < this.subsetGlyphInCoverage.length; ++i) {
                if (this.subsetGlyphInCoverage[i - 1] || !this.subsetGlyphInCoverage[i]) continue;
                ++nRanges;
            }
            return nRanges;
        }
    }
}

