/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.GposSubsetter;
import com.adobe.fontengine.font.opentype.Gsub;
import com.adobe.fontengine.font.opentype.LookupTable;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.OpticalSizeData;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public final class Gpos
extends LookupTable {
    protected Gpos(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
    }

    @Override
    protected int getScriptListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 4);
    }

    @Override
    protected int getFeatureListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 6);
    }

    @Override
    protected int getLookupListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 8);
    }

    @Override
    protected LookupTable.LookupResult applyLookupSubtable(int lookupType, int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        switch (lookupType) {
            case 1: {
                return this.applySinglePos(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 2: {
                return this.applyPairPos(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 3: {
                return this.applyCursiveAttachment(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 4: {
                return this.applyMarkToBase(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 5: {
                return this.applyMarkToLigature(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 6: {
                return this.applyMarkToMark(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 7: {
                return this.applyContextualSubtable(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 8: {
                return this.applyChainingContextualSubtable(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 9: {
                return this.applyExtensionSubtable(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("Invalid GPOS lookup type (" + lookupType + ")");
    }

    protected int getValueRecordSize(int valueFormat) {
        int size = 0;
        if ((valueFormat & 1) != 0) {
            size += 2;
        }
        if ((valueFormat & 2) != 0) {
            size += 2;
        }
        if ((valueFormat & 4) != 0) {
            size += 2;
        }
        if ((valueFormat & 8) != 0) {
            size += 2;
        }
        if ((valueFormat & 0x10) != 0) {
            size += 2;
        }
        if ((valueFormat & 0x20) != 0) {
            size += 2;
        }
        if ((valueFormat & 0x40) != 0) {
            size += 2;
        }
        if ((valueFormat & 0x80) != 0) {
            size += 2;
        }
        return size;
    }

    protected void applyValueRecord(AttributedRun run, int pos, int offset, int valueFormat) throws InvalidFontException {
        int xPlacement = 0;
        int yPlacement = 0;
        int xAdvance = 0;
        int yAdvance = 0;
        if ((valueFormat & 1) != 0) {
            xPlacement = this.data.getint16(offset);
            offset += 2;
        }
        if ((valueFormat & 2) != 0) {
            yPlacement = this.data.getint16(offset);
            offset += 2;
        }
        if ((valueFormat & 4) != 0) {
            xAdvance = this.data.getint16(offset);
            offset += 2;
        }
        if ((valueFormat & 8) != 0) {
            yAdvance = this.data.getint16(offset);
            offset += 2;
        }
        run.adjustPlacementAndAdvance(pos, xPlacement, yPlacement, xAdvance, yAdvance);
    }

    protected LookupTable.LookupResult applySinglePos(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applySinglePosFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 2: {
                return this.applySinglePosFormat2(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS single pos format (" + format + ")");
    }

    protected LookupTable.LookupResult applySinglePosFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        if (this.getCoverageIndex(run.elementAt(inPos), coverageOffset) == -1) {
            return lookupNotApplied;
        }
        if (!selector.isApplied(run, inPos)) {
            return lookupNotApplied;
        }
        int valueFormat = this.data.getuint16(stOffset + 4);
        this.applyValueRecord(run, inPos, stOffset + 6, valueFormat);
        return new LookupTable.LookupResult(true, inPos + 1, 0);
    }

    protected LookupTable.LookupResult applySinglePosFormat2(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        int ci = this.getCoverageIndex(run.elementAt(inPos), coverageOffset);
        if (ci == -1) {
            return lookupNotApplied;
        }
        if (!selector.isApplied(run, inPos)) {
            return lookupNotApplied;
        }
        int valueFormat = this.data.getuint16(stOffset + 4);
        int valueRecordOffset = stOffset + 8 + this.getValueRecordSize(valueFormat) * ci;
        this.applyValueRecord(run, inPos, valueRecordOffset, valueFormat);
        return new LookupTable.LookupResult(true, inPos + 1, 0);
    }

    protected LookupTable.LookupResult applyPairPos(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applyPairPosFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 2: {
                return this.applyPairPosFormat2(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS pair pos format (" + format + ")");
    }

    protected LookupTable.LookupResult applyPairPosFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        int ci = this.getCoverageIndex(run.elementAt(inPos), coverageOffset);
        if (ci == -1) {
            return lookupNotApplied;
        }
        int firstGlyphPos = inPos++;
        while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
            ++inPos;
        }
        if (limit <= inPos || !selector.isApplied(run, firstGlyphPos, inPos)) {
            return lookupNotApplied;
        }
        int valueFormat1 = this.data.getuint16(stOffset + 4);
        int valueFormat2 = this.data.getuint16(stOffset + 6);
        int valueRecord1Size = this.getValueRecordSize(valueFormat1);
        int valueRecord2Size = this.getValueRecordSize(valueFormat2);
        int pairValueRecordSize = 2 + valueRecord1Size + valueRecord2Size;
        int pairSetOffset = this.data.getOffset(stOffset, 10 + 2 * ci);
        int pairValueCount = this.data.getuint16(pairSetOffset);
        for (int p = 0; p < pairValueCount; ++p) {
            int pairValueRecordOffset = pairSetOffset + 2 + pairValueRecordSize * p;
            int secondGlyph = this.data.getuint16(pairValueRecordOffset);
            if (secondGlyph != run.elementAt(inPos)) continue;
            if (valueFormat1 != 0) {
                this.applyValueRecord(run, firstGlyphPos, pairValueRecordOffset + 2, valueFormat1);
            }
            if (valueFormat2 != 0) {
                this.applyValueRecord(run, inPos, pairValueRecordOffset + 2 + valueRecord1Size, valueFormat2);
            }
            if (valueFormat2 == 0) {
                return new LookupTable.LookupResult(true, inPos, 0);
            }
            return new LookupTable.LookupResult(true, inPos + 1, 0);
        }
        return lookupNotApplied;
    }

    protected LookupTable.LookupResult applyPairPosFormat2(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        if (this.getCoverageIndex(run.elementAt(inPos), coverageOffset) == -1) {
            return lookupNotApplied;
        }
        int firstGlyphPos = inPos++;
        while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
            ++inPos;
        }
        if (limit <= inPos || !selector.isApplied(run, firstGlyphPos, inPos)) {
            return lookupNotApplied;
        }
        int firstGlyphClass = this.getClassIndex(run.elementAt(firstGlyphPos), this.data.getOffset(stOffset, 8));
        int secondGlyphClass = this.getClassIndex(run.elementAt(inPos), this.data.getOffset(stOffset, 10));
        int class2Count = this.data.getuint16(stOffset + 14);
        int valueFormat1 = this.data.getuint16(stOffset + 4);
        int valueFormat2 = this.data.getuint16(stOffset + 6);
        int valueRecord1Size = this.getValueRecordSize(valueFormat1);
        int valueRecord2Size = this.getValueRecordSize(valueFormat2);
        int class2RecordSize = valueRecord1Size + valueRecord2Size;
        int class1RecordSize = class2RecordSize * class2Count;
        int class2RecordOffset = stOffset + 16 + firstGlyphClass * class1RecordSize + secondGlyphClass * class2RecordSize;
        if (valueFormat1 != 0) {
            this.applyValueRecord(run, firstGlyphPos, class2RecordOffset, valueFormat1);
        }
        if (valueFormat2 != 0) {
            this.applyValueRecord(run, inPos, class2RecordOffset + valueRecord1Size, valueFormat2);
        }
        if (valueFormat2 == 0) {
            return new LookupTable.LookupResult(true, inPos, 0);
        }
        return new LookupTable.LookupResult(true, inPos + 1, 0);
    }

    protected LookupTable.LookupResult applyCursiveAttachment(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applyCursiveAttachmentFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS cursive attachment format (" + format + ")");
    }

    protected LookupTable.LookupResult applyCursiveAttachmentFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int secondPos;
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int firstPos = curGlyph;
        int firstCoverageIndex = this.getCoverageIndex(run.elementAt(firstPos), coverageOffset);
        if (firstCoverageIndex == -1) {
            return lookupNotApplied;
        }
        for (secondPos = curGlyph + 1; secondPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(secondPos)); ++secondPos) {
        }
        if (limit <= secondPos || !selector.isApplied(run, firstPos, secondPos)) {
            return lookupNotApplied;
        }
        int secondCoverageIndex = this.getCoverageIndex(run.elementAt(secondPos), coverageOffset);
        if (secondCoverageIndex == -1) {
            return lookupNotApplied;
        }
        int firstAnchorOffset = this.data.getOffset(stOffset, 6 + firstCoverageIndex * 4 + 2);
        int secondAnchorOffset = this.data.getOffset(stOffset, 6 + secondCoverageIndex * 4);
        if (firstAnchorOffset == 0 || secondAnchorOffset == 0) {
            return lookupNotApplied;
        }
        this.mergeAnchors(run, firstPos, firstAnchorOffset, secondPos, secondAnchorOffset);
        return new LookupTable.LookupResult(true, firstPos + 1, 0);
    }

    protected LookupTable.LookupResult applyMarkToBase(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applyMarkToBaseFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS mark to base format (" + format + ")");
    }

    protected LookupTable.LookupResult applyMarkToBaseFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int basePos;
        int markCoverageOffset = this.data.getOffset(stOffset, 2);
        int baseCoverageOffset = this.data.getOffset(stOffset, 4);
        int inPos = curGlyph;
        if (this.getCoverageIndex(run.elementAt(inPos), markCoverageOffset) == -1) {
            return lookupNotApplied;
        }
        for (basePos = curGlyph - 1; start <= basePos && (this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(basePos)) || gdef != null && gdef.getGlyphClass(run.elementAt(basePos)) == 3); --basePos) {
        }
        if (basePos < start || this.getCoverageIndex(run.elementAt(basePos), baseCoverageOffset) == -1) {
            return lookupNotApplied;
        }
        if (!selector.isApplied(run, basePos, inPos)) {
            return lookupNotApplied;
        }
        int classCount = this.data.getuint16(stOffset + 6);
        int markCoverageIndex = this.getCoverageIndex(run.elementAt(inPos), markCoverageOffset);
        int markArrayOffset = this.data.getOffset(stOffset, 8);
        int markClass = this.data.getuint16(markArrayOffset + 2 + 4 * markCoverageIndex);
        int markAnchorOffset = this.data.getOffset(markArrayOffset, 2 + 4 * markCoverageIndex + 2);
        int baseCoverageIndex = this.getCoverageIndex(run.elementAt(basePos), baseCoverageOffset);
        int baseArrayOffset = this.data.getOffset(stOffset, 10);
        int baseAnchorOffset = this.data.getOffset(baseArrayOffset, 2 + 2 * (classCount * baseCoverageIndex + markClass));
        this.mergeAnchors(run, basePos, baseAnchorOffset, inPos, markAnchorOffset);
        return new LookupTable.LookupResult(true, inPos + 1, 0);
    }

    protected LookupTable.LookupResult applyMarkToLigature(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applyMarkToLigatureFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS mark to ligature format (" + format + ")");
    }

    protected LookupTable.LookupResult applyMarkToLigatureFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int ligPos;
        int markCoverageOffset = this.data.getOffset(stOffset, 2);
        int ligCoverageOffset = this.data.getOffset(stOffset, 4);
        int inPos = curGlyph;
        if (this.getCoverageIndex(run.elementAt(inPos), markCoverageOffset) == -1) {
            return lookupNotApplied;
        }
        for (ligPos = curGlyph - 1; start <= ligPos && (this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(ligPos)) || gdef != null && gdef.getGlyphClass(run.elementAt(ligPos)) == 3); --ligPos) {
        }
        if (ligPos < start || this.getCoverageIndex(run.elementAt(ligPos), ligCoverageOffset) == -1) {
            return lookupNotApplied;
        }
        if (!selector.isApplied(run, ligPos, inPos)) {
            return lookupNotApplied;
        }
        int classCount = this.data.getuint16(stOffset + 6);
        int markCoverageIndex = this.getCoverageIndex(run.elementAt(inPos), markCoverageOffset);
        int markArrayOffset = this.data.getOffset(stOffset, 8);
        int markClass = this.data.getuint16(markArrayOffset + 2 + 4 * markCoverageIndex);
        int markAnchorOffset = this.data.getOffset(markArrayOffset, 2 + 4 * markCoverageIndex + 2);
        int ligCoverageIndex = this.getCoverageIndex(run.elementAt(ligPos), ligCoverageOffset);
        int ligArrayOffset = this.data.getOffset(stOffset, 10);
        int ligAttachOffset = this.data.getOffset(ligArrayOffset, 2 + 2 * ligCoverageIndex);
        Integer ligatureComponent = (Integer)run.getElementStyle(inPos, Gsub.ligatureComponentAttribute);
        int lc = ligatureComponent == null ? 0 : ligatureComponent;
        int ligAnchorOffset = this.data.getOffset(ligAttachOffset, 2 + 2 * (classCount * lc + markClass));
        this.mergeAnchors(run, ligPos, ligAnchorOffset, inPos, markAnchorOffset);
        return new LookupTable.LookupResult(true, inPos + 1, 0);
    }

    protected LookupTable.LookupResult applyMarkToMark(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applyMarkToMarkFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS cursive attachment format (" + format + ")");
    }

    protected LookupTable.LookupResult applyMarkToMarkFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        Integer mark2LigatureComponent;
        int mark2Pos;
        int markCoverageOffset = this.data.getOffset(stOffset, 2);
        int mark2CoverageOffset = this.data.getOffset(stOffset, 4);
        int inPos = curGlyph;
        if (this.getCoverageIndex(run.elementAt(inPos), markCoverageOffset) == -1) {
            return lookupNotApplied;
        }
        for (mark2Pos = curGlyph - 1; start <= mark2Pos && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(mark2Pos)); --mark2Pos) {
        }
        if (mark2Pos < start || this.getCoverageIndex(run.elementAt(mark2Pos), mark2CoverageOffset) == -1) {
            return lookupNotApplied;
        }
        if (!selector.isApplied(run, mark2Pos, inPos)) {
            return lookupNotApplied;
        }
        Integer inPosLigatureComponent = (Integer)run.getElementStyle(inPos, Gsub.ligatureComponentAttribute);
        if ((inPosLigatureComponent == null ? 0 : inPosLigatureComponent) != ((mark2LigatureComponent = (Integer)run.getElementStyle(mark2Pos, Gsub.ligatureComponentAttribute)) == null ? 0 : mark2LigatureComponent)) {
            return lookupNotApplied;
        }
        int classCount = this.data.getuint16(stOffset + 6);
        int markCoverageIndex = this.getCoverageIndex(run.elementAt(inPos), markCoverageOffset);
        int markArrayOffset = this.data.getOffset(stOffset, 8);
        int markClass = this.data.getuint16(markArrayOffset + 2 + 4 * markCoverageIndex);
        int markAnchorOffset = this.data.getOffset(markArrayOffset, 2 + 4 * markCoverageIndex + 2);
        int mark2CoverageIndex = this.getCoverageIndex(run.elementAt(mark2Pos), mark2CoverageOffset);
        int mark2ArrayOffset = this.data.getOffset(stOffset, 10);
        int mark2AnchorOffset = this.data.getOffset(mark2ArrayOffset, 2 + 2 * (classCount * mark2CoverageIndex + markClass));
        this.mergeAnchors(run, mark2Pos, mark2AnchorOffset, inPos, markAnchorOffset);
        return new LookupTable.LookupResult(true, inPos + 1, 0);
    }

    protected void mergeAnchors(AttributedRun run, int pos1, int offset1, int pos2, int offset2) throws InvalidFontException {
        int a1x = this.data.getint16(offset1 + 2);
        int a1y = this.data.getint16(offset1 + 4);
        int a2x = this.data.getint16(offset2 + 2);
        int a2y = this.data.getint16(offset2 + 4);
        double deltaX = (double)a1x + run.getElementXPlacement(pos1) - (double)a2x - run.getElementXPlacement(pos2);
        double deltaY = (double)a1y + run.getElementYPlacement(pos1) - (double)a2y - run.getElementYPlacement(pos2);
        if ((Integer)run.getElementStyle(pos1, ElementAttribute.bidiLevel) % 2 == 0) {
            for (int i = pos1; i < pos2; ++i) {
                deltaX -= run.getElementXAdvance(i);
                deltaY -= run.getElementYAdvance(i);
            }
        } else {
            for (int i = pos1 + 1; i <= pos2; ++i) {
                deltaX += run.getElementXAdvance(i);
                deltaY += run.getElementYAdvance(i);
            }
        }
        run.adjustPlacementAndAdvance(pos2, deltaX, deltaY, 0.0, 0.0);
    }

    public OpticalSizeData getOpticalSizeData(boolean compensateForFontBug) throws InvalidFontException {
        int featureListOffset = this.getFeatureListOffset();
        int featureCount = this.data.getuint16(featureListOffset);
        for (int i = 0; i < featureCount; ++i) {
            if (this.data.getint32(featureListOffset + 2 + 6 * i) != Tag.feature_size) continue;
            int featureOffset = this.data.getOffset(featureListOffset, 2 + 6 * i + 4);
            int featureParamsOffset = this.data.getOffset(0, featureOffset);
            featureParamsOffset = compensateForFontBug ? (featureParamsOffset += featureListOffset) : (featureParamsOffset += featureOffset);
            return new OpticalSizeData(this.data.getuint16(featureParamsOffset), this.data.getuint16(featureParamsOffset + 2), this.data.getuint16(featureParamsOffset + 4), this.data.getuint16(featureParamsOffset + 6), this.data.getuint16(featureParamsOffset + 8));
        }
        return null;
    }

    void subsetAndStream(Subset subset, TreeMap lookups, Map tables, int numGlyphs, boolean preserveNonEmptyKernFeatures) throws InvalidFontException, UnsupportedFontException {
        GposSubsetter subsetter = new GposSubsetter(this, numGlyphs, preserveNonEmptyKernFeatures);
        OTByteArray.OTByteArrayBuilder newData = subsetter.subsetAndStream(lookups, subset);
        tables.put(new Integer(1196445523), newData);
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1196445523), newData);
    }
}

