/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.PDFEncodingBuilderImpl;

public abstract class PDFEncodingBuilder {
    public static PDFEncodingBuilder getInstance(Font font, Subset subset) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData data = ((FontImpl)font).getFontData();
        if (data instanceof OpenTypeFont && ((OpenTypeFont)data).cmap != null) {
            return new PDFEncodingBuilderImpl((OpenTypeFont)data, subset);
        }
        return null;
    }

    public abstract int getCodePoint(int var1, Encoding var2);

    public abstract Encoding getEncoding(int var1);

    public static final class Encoding {
        private final String description;
        public static final Encoding UNICODE = new Encoding("Unicode Scalar Values");
        public static final Encoding MS_SHIFT_JIS = new Encoding("Shift JIS");
        public static final Encoding MS_PRC = new Encoding("PRC");
        public static final Encoding MS_BIG5 = new Encoding("Big 5");
        public static final Encoding MS_WANSUNG = new Encoding("Wansung");
        public static final Encoding MS_JOHAB = new Encoding("Johab");

        private Encoding(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

