/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.charset;

import com.adobe.agl.charset.CharsetDecoderICU;
import com.adobe.agl.charset.CharsetEncoderICU;
import com.adobe.agl.charset.CharsetICU;
import com.adobe.agl.text.UTF16;
import com.adobe.agl.text.UnicodeSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.text.Bidi;

public class CharsetMacArabic
extends CharsetICU {
    private static final byte[] fromUSubstitution = new byte[]{26};
    protected static final char LRE = '\u202a';
    protected static final char RLE = '\u202b';
    protected static final char PDF = '\u202c';
    protected static final char LRO = '\u202d';
    protected static final char RLO = '\u202e';
    protected static final char[] NLF = System.getProperty("line.separator").toCharArray();
    protected static final char LS = '\u2028';
    protected static final char PS = '\u2029';
    protected static final int INVALID_CHAR = 65535;
    protected static final int ASCII_END = 127;
    protected static final int NO_CHAR_MARKER = 65534;
    protected static final int BYTE_MASK = 255;
    protected static final byte ARABIC_DIGIT_MIN = -80;
    protected static final byte ARABIC_DIGIT_MAX = -71;
    private UConverterDataMacArabic extraInfo = null;
    protected static final char[] fromUnicodeTable = new char[]{'\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00ac', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00bb', '\uffff', '\uffff', '\uffff', '\u00bf', '\uffff', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\uffff', '\u00bc', '\u00bd', '\u00be', '\uffff', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00a5', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00f4', '\uffff', '\u00fb', '\u00fc', '\u00fd', '\u00f3', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00f5', '\uffff', '\u00f9', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00fa', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00fe', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0081', '\uffff', '\uffff', '\uffff', '\u00f7', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u008c', '\uffff', '\uffff', '\uffff', '\u00f8', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u008b', '\u0098', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0080', '\uffff', '\uffff', '\u0082', '\uffff', '\u0083', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0084', '\u00ff', '\uffff', '\uffff', '\u00f6', '\u0085', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0086', '\uffff', '\uffff', '\uffff', '\u0088', '\u0087', '\u0089', '\uffff', '\u008a', '\uffff', '\uffff', '\u008d', '\u008f', '\u008e', '\u0090', '\u0091', '\uffff', '\u0092', '\u0094', '\u0095', '\uffff', '\u0096', '\uffff', '\u0097', '\u0099', '\uffff', '\u009a', '\u009b', '\uffff', '\u009d', '\u009c', '\u009e', '\u009f', '\uffff', '\uffff', '\uffff'};
    protected static final char[][] toUnicodeTable = new char[][]{{'\u0000', '\u0000'}, {'\u0001', '\u0000'}, {'\u0002', '\u0000'}, {'\u0003', '\u0000'}, {'\u0004', '\u0000'}, {'\u0005', '\u0000'}, {'\u0006', '\u0000'}, {'\u0007', '\u0000'}, {'\b', '\u0000'}, {'\t', '\u0000'}, {'\n', '\u0000'}, {'\u000b', '\u0000'}, {'\f', '\u0000'}, {'\r', '\u0000'}, {'\u000e', '\u0000'}, {'\u000f', '\u0000'}, {'\u0010', '\u0000'}, {'\u0011', '\u0000'}, {'\u0012', '\u0000'}, {'\u0013', '\u0000'}, {'\u0014', '\u0000'}, {'\u0015', '\u0000'}, {'\u0016', '\u0000'}, {'\u0017', '\u0000'}, {'\u0018', '\u0000'}, {'\u0019', '\u0000'}, {'\u001a', '\u0000'}, {'\u001b', '\u0000'}, {'\u001c', '\u0000'}, {'\u001d', '\u0000'}, {'\u001e', '\u0000'}, {'\u001f', '\u0000'}, {' ', '\u202d'}, {'!', '\u202d'}, {'\"', '\u202d'}, {'#', '\u202d'}, {'$', '\u202d'}, {'%', '\u202d'}, {'&', '\u202d'}, {'\'', '\u202d'}, {'(', '\u202d'}, {')', '\u202d'}, {'*', '\u202d'}, {'+', '\u202d'}, {',', '\u202d'}, {'-', '\u202d'}, {'.', '\u202d'}, {'/', '\u202d'}, {'0', '\u0000'}, {'1', '\u0000'}, {'2', '\u0000'}, {'3', '\u0000'}, {'4', '\u0000'}, {'5', '\u0000'}, {'6', '\u0000'}, {'7', '\u0000'}, {'8', '\u0000'}, {'9', '\u0000'}, {':', '\u202d'}, {';', '\u202d'}, {'<', '\u202d'}, {'=', '\u202d'}, {'>', '\u202d'}, {'?', '\u202d'}, {'@', '\u0000'}, {'A', '\u0000'}, {'B', '\u0000'}, {'C', '\u0000'}, {'D', '\u0000'}, {'E', '\u0000'}, {'F', '\u0000'}, {'G', '\u0000'}, {'H', '\u0000'}, {'I', '\u0000'}, {'J', '\u0000'}, {'K', '\u0000'}, {'L', '\u0000'}, {'M', '\u0000'}, {'N', '\u0000'}, {'O', '\u0000'}, {'P', '\u0000'}, {'Q', '\u0000'}, {'R', '\u0000'}, {'S', '\u0000'}, {'T', '\u0000'}, {'U', '\u0000'}, {'V', '\u0000'}, {'W', '\u0000'}, {'X', '\u0000'}, {'Y', '\u0000'}, {'Z', '\u0000'}, {'[', '\u202d'}, {'\\', '\u202d'}, {']', '\u202d'}, {'^', '\u202d'}, {'_', '\u202d'}, {'`', '\u0000'}, {'a', '\u0000'}, {'b', '\u0000'}, {'c', '\u0000'}, {'d', '\u0000'}, {'e', '\u0000'}, {'f', '\u0000'}, {'g', '\u0000'}, {'h', '\u0000'}, {'i', '\u0000'}, {'j', '\u0000'}, {'k', '\u0000'}, {'l', '\u0000'}, {'m', '\u0000'}, {'n', '\u0000'}, {'o', '\u0000'}, {'p', '\u0000'}, {'q', '\u0000'}, {'r', '\u0000'}, {'s', '\u0000'}, {'t', '\u0000'}, {'u', '\u0000'}, {'v', '\u0000'}, {'w', '\u0000'}, {'x', '\u0000'}, {'y', '\u0000'}, {'z', '\u0000'}, {'{', '\u202d'}, {'|', '\u202d'}, {'}', '\u202d'}, {'~', '\u0000'}, {'\u007f', '\u0000'}, {'\u00c4', '\u0000'}, {'\u00a0', '\u202e'}, {'\u00c7', '\u0000'}, {'\u00c9', '\u0000'}, {'\u00d1', '\u0000'}, {'\u00d6', '\u0000'}, {'\u00dc', '\u0000'}, {'\u00e1', '\u0000'}, {'\u00e0', '\u0000'}, {'\u00e2', '\u0000'}, {'\u00e4', '\u0000'}, {'\u06ba', '\u0000'}, {'\u00ab', '\u202e'}, {'\u00e7', '\u0000'}, {'\u00e9', '\u0000'}, {'\u00e8', '\u0000'}, {'\u00ea', '\u0000'}, {'\u00eb', '\u0000'}, {'\u00ed', '\u0000'}, {'\u2026', '\u202e'}, {'\u00ee', '\u0000'}, {'\u00ef', '\u0000'}, {'\u00f1', '\u0000'}, {'\u00f3', '\u0000'}, {'\u00bb', '\u202e'}, {'\u00f4', '\u0000'}, {'\u00f6', '\u0000'}, {'\u00f7', '\u202e'}, {'\u00fa', '\u0000'}, {'\u00f9', '\u0000'}, {'\u00fb', '\u0000'}, {'\u00fc', '\u0000'}, {' ', '\u202e'}, {'!', '\u202e'}, {'\"', '\u202e'}, {'#', '\u202e'}, {'$', '\u202e'}, {'\u066a', '\u0000'}, {'&', '\u202e'}, {'\'', '\u202e'}, {'(', '\u202e'}, {')', '\u202e'}, {'*', '\u202e'}, {'+', '\u202e'}, {'\u060c', '\u0000'}, {'-', '\u202e'}, {'.', '\u202e'}, {'/', '\u202e'}, {'\u0660', '\u202e'}, {'\u0661', '\u202e'}, {'\u0662', '\u202e'}, {'\u0663', '\u202e'}, {'\u0664', '\u202e'}, {'\u0665', '\u202e'}, {'\u0666', '\u202e'}, {'\u0667', '\u202e'}, {'\u0668', '\u202e'}, {'\u0669', '\u202e'}, {':', '\u202e'}, {'\u061b', '\u0000'}, {'<', '\u202e'}, {'=', '\u202e'}, {'>', '\u202e'}, {'\u061f', '\u0000'}, {'\u274a', '\u202e'}, {'\u0621', '\u0000'}, {'\u0622', '\u0000'}, {'\u0623', '\u0000'}, {'\u0624', '\u0000'}, {'\u0625', '\u0000'}, {'\u0626', '\u0000'}, {'\u0627', '\u0000'}, {'\u0628', '\u0000'}, {'\u0629', '\u0000'}, {'\u062a', '\u0000'}, {'\u062b', '\u0000'}, {'\u062c', '\u0000'}, {'\u062d', '\u0000'}, {'\u062e', '\u0000'}, {'\u062f', '\u0000'}, {'\u0630', '\u0000'}, {'\u0631', '\u0000'}, {'\u0632', '\u0000'}, {'\u0633', '\u0000'}, {'\u0634', '\u0000'}, {'\u0635', '\u0000'}, {'\u0636', '\u0000'}, {'\u0637', '\u0000'}, {'\u0638', '\u0000'}, {'\u0639', '\u0000'}, {'\u063a', '\u0000'}, {'[', '\u202e'}, {'\\', '\u202e'}, {']', '\u202e'}, {'^', '\u202e'}, {'_', '\u202e'}, {'\u0640', '\u0000'}, {'\u0641', '\u0000'}, {'\u0642', '\u0000'}, {'\u0643', '\u0000'}, {'\u0644', '\u0000'}, {'\u0645', '\u0000'}, {'\u0646', '\u0000'}, {'\u0647', '\u0000'}, {'\u0648', '\u0000'}, {'\u0649', '\u0000'}, {'\u064a', '\u0000'}, {'\u064b', '\u0000'}, {'\u064c', '\u0000'}, {'\u064d', '\u0000'}, {'\u064e', '\u0000'}, {'\u064f', '\u0000'}, {'\u0650', '\u0000'}, {'\u0651', '\u0000'}, {'\u0652', '\u0000'}, {'\u067e', '\u0000'}, {'\u0679', '\u0000'}, {'\u0686', '\u0000'}, {'\u06d5', '\u0000'}, {'\u06a4', '\u0000'}, {'\u06af', '\u0000'}, {'\u0688', '\u0000'}, {'\u0691', '\u0000'}, {'{', '\u202e'}, {'|', '\u202e'}, {'}', '\u202e'}, {'\u0698', '\u0000'}, {'\u06d2', '\u0000'}};

    protected boolean isNLF(StringBuffer fromUPara, int paraIndex) {
        for (int i = 1; i < NLF.length; ++i) {
            if (fromUPara.charAt(paraIndex++) == NLF[i]) continue;
            return false;
        }
        return true;
    }

    protected static boolean isValidMacArabicUnicode(int uVal) {
        return uVal < 255 || uVal <= 1749 && uVal >= 1548 || uVal == 8230 || uVal == 10058 || uVal <= 8238 && uVal >= 8234 || uVal == 8232 || uVal == 8233;
    }

    public CharsetMacArabic(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        this.extraInfo = new UConverterDataMacArabic();
        if (this.extraInfo != null) {
            UConverterDataMacArabic converterData = this.extraInfo;
            converterData.contextDirectionToUnicode = (char)65534;
            converterData.name = "MacArabic";
        }
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderMacArabic(this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderMacArabic(this);
    }

    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
    }

    class CharsetEncoderMacArabic
    extends CharsetEncoderICU {
        private CharsetICU mycs;

        public CharsetEncoderMacArabic(CharsetICU cs) {
            super(cs, fromUSubstitution);
            this.mycs = cs;
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
        }

        public boolean canEncode(int[] input) {
            char[] arr = new char[input.length];
            for (int i = 0; i < input.length; ++i) {
                UTF16.append(arr, i, input[i]);
            }
            CharsetEncoderICU mycse = (CharsetEncoderICU)this.mycs.newEncoder();
            CharBuffer in = CharBuffer.wrap(arr);
            ByteBuffer out = ByteBuffer.allocate(in.length() * (int)mycse.maxBytesPerChar() + 1);
            mycse.setFallbackUsed(this.isFallbackUsed());
            CoderResult res = mycse.encodeLoop(in, out, null, false);
            return !res.isUnmappable();
        }

        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int realSourceArrayIndex = source.position();
            int targetByteUnit = 0;
            char sourceChar = '\u0000';
            int curParaIndex = 0;
            if (!source.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            UConverterDataMacArabic converterData = CharsetMacArabic.this.extraInfo;
            if (!flush) {
                Bidi bidiPara;
                while (source.hasRemaining()) {
                    if (!converterData.isInParagraph) {
                        if (realSourceArrayIndex < source.limit()) {
                            sourceChar = source.get(realSourceArrayIndex++);
                            converterData.fromUPara.append(sourceChar);
                            if (sourceChar != '\u2029') continue;
                            converterData.isInParagraph = true;
                            converterData.realSourceArrayIndex = realSourceArrayIndex;
                            continue;
                        }
                        source.position(source.limit());
                        continue;
                    }
                    bidiPara = new Bidi(converterData.fromUPara.toString(), -1);
                    while (converterData.paraIndex < converterData.fromUPara.length()) {
                        curParaIndex = converterData.paraIndex;
                        int pos = source.position();
                        source.position(pos + 1);
                        sourceChar = converterData.fromUPara.charAt(converterData.paraIndex++);
                        targetByteUnit = 65535;
                        if (CharsetMacArabic.isValidMacArabicUnicode(sourceChar)) {
                            if (sourceChar <= '\u202e' && sourceChar >= '\u202a') continue;
                            if (sourceChar == '\u2029' || sourceChar == '\u2028') {
                                targetByteUnit = (byte)NLF[0];
                            } else if (sourceChar <= '\u007f') {
                                targetByteUnit = bidiPara.getLevelAt(curParaIndex) % 2 == 1 ? (sourceChar >= ' ' && sourceChar <= '/' && sourceChar != '%' && sourceChar != ',' ? (0xF & sourceChar) + 160 : (sourceChar == ':' ? 186 : (sourceChar >= '<' && sourceChar <= '>' || sourceChar >= '[' && sourceChar <= '_' || sourceChar >= '{' && sourceChar <= '}' ? fromUnicodeTable[sourceChar & 0xFF] : (int)sourceChar))) : (int)sourceChar;
                            } else {
                                switch (sourceChar) {
                                    case '\u2026': {
                                        targetByteUnit = 147;
                                        break;
                                    }
                                    case '\u274a': {
                                        targetByteUnit = 192;
                                        break;
                                    }
                                    default: {
                                        targetByteUnit = fromUnicodeTable[sourceChar & 0xFF];
                                    }
                                }
                            }
                        }
                        if (targetByteUnit != 65535) {
                            if (sourceChar == '\u2028' || sourceChar == '\u2029') {
                                for (int i = 0; i < NLF.length && !(cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit = (int)((byte)NLF[i]))).isOverflow(); ++i) {
                                }
                                continue;
                            }
                            cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit);
                            if (!cr.isOverflow()) continue;
                            break;
                        }
                        return CoderResult.unmappableForLength(1);
                    }
                    if (cr.isOverflow()) break;
                    converterData.fromUPara = new StringBuffer();
                    converterData.paraIndex = 0;
                    converterData.isInParagraph = false;
                    realSourceArrayIndex = converterData.realSourceArrayIndex;
                }
                if (converterData.fromUPara.length() > 0) {
                    bidiPara = new Bidi(converterData.fromUPara.toString(), -1);
                    while (converterData.paraIndex < converterData.fromUPara.length()) {
                        curParaIndex = converterData.paraIndex;
                        sourceChar = converterData.fromUPara.charAt(converterData.paraIndex++);
                        targetByteUnit = 65535;
                        if (CharsetMacArabic.isValidMacArabicUnicode(sourceChar)) {
                            if (sourceChar <= '\u202e' && sourceChar >= '\u202a') continue;
                            if (sourceChar == '\u2029' || sourceChar == '\u2028') {
                                targetByteUnit = (byte)NLF[0];
                            } else if (sourceChar <= '\u007f') {
                                targetByteUnit = bidiPara.getLevelAt(curParaIndex) % 2 == 1 ? (sourceChar >= ' ' && sourceChar <= '/' && sourceChar != '%' && sourceChar != ',' ? (0xF & sourceChar) + 160 : (sourceChar == ':' ? 186 : (sourceChar >= '<' && sourceChar <= '>' || sourceChar >= '[' && sourceChar <= '_' || sourceChar >= '{' && sourceChar <= '}' ? fromUnicodeTable[sourceChar & 0xFF] : (int)sourceChar))) : (int)sourceChar;
                            } else {
                                switch (sourceChar) {
                                    case '\u2026': {
                                        targetByteUnit = 147;
                                        break;
                                    }
                                    case '\u274a': {
                                        targetByteUnit = 192;
                                        break;
                                    }
                                    default: {
                                        targetByteUnit = fromUnicodeTable[sourceChar & 0xFF];
                                    }
                                }
                            }
                        }
                        if (targetByteUnit != 65535) {
                            if (sourceChar == '\u2028' || sourceChar == '\u2029') {
                                for (int i = 0; i < NLF.length && !(cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit = (int)((byte)NLF[i]))).isOverflow(); ++i) {
                                }
                                continue;
                            }
                            cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit);
                            if (!cr.isOverflow()) continue;
                            break;
                        }
                        return CoderResult.unmappableForLength(1);
                    }
                    if (!cr.isOverflow()) {
                        converterData.fromUPara = new StringBuffer();
                        converterData.paraIndex = 0;
                    }
                }
            } else if (converterData.fromUPara.length() > 0) {
                Bidi bidiPara = new Bidi(converterData.fromUPara.toString(), -1);
                while (converterData.paraIndex < converterData.fromUPara.length()) {
                    curParaIndex = converterData.paraIndex;
                    sourceChar = converterData.fromUPara.charAt(converterData.paraIndex++);
                    targetByteUnit = 65535;
                    if (CharsetMacArabic.isValidMacArabicUnicode(sourceChar)) {
                        if (sourceChar <= '\u202e' && sourceChar >= '\u202a') continue;
                        if (sourceChar == '\u2029' || sourceChar == '\u2028') {
                            targetByteUnit = (byte)NLF[0];
                        } else if (sourceChar <= '\u007f') {
                            targetByteUnit = bidiPara.getLevelAt(curParaIndex) % 2 == 1 ? (sourceChar >= ' ' && sourceChar <= '/' && sourceChar != '%' && sourceChar != ',' ? (0xF & sourceChar) + 160 : (sourceChar == ':' ? 186 : (sourceChar >= '<' && sourceChar <= '>' || sourceChar >= '[' && sourceChar <= '_' || sourceChar >= '{' && sourceChar <= '}' ? fromUnicodeTable[sourceChar & 0xFF] : (int)sourceChar))) : (int)sourceChar;
                        } else {
                            switch (sourceChar) {
                                case '\u2026': {
                                    targetByteUnit = 147;
                                    break;
                                }
                                case '\u274a': {
                                    targetByteUnit = 192;
                                    break;
                                }
                                default: {
                                    targetByteUnit = fromUnicodeTable[sourceChar & 0xFF];
                                }
                            }
                        }
                    }
                    if (targetByteUnit != 65535) {
                        if (sourceChar == '\u2028' || sourceChar == '\u2029') {
                            for (int i = 0; i < NLF.length && !(cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit = (int)((byte)NLF[i]))).isOverflow(); ++i) {
                            }
                            continue;
                        }
                        cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit);
                        if (!cr.isOverflow()) continue;
                        break;
                    }
                    return CoderResult.unmappableForLength(1);
                }
                if (!cr.isOverflow()) {
                    converterData.fromUPara = new StringBuffer();
                    converterData.paraIndex = 0;
                    source.position(0);
                }
            }
            return cr;
        }

        private final CoderResult encodeChar(CharBuffer source, ByteBuffer target, IntBuffer offsets, char ch) {
            CoderResult cr = null;
            return cr;
        }

        private CoderResult WriteToTargetFromU(IntBuffer offsets, CharBuffer source, ByteBuffer target, int targetByteUnit) {
            CoderResult cr = CoderResult.UNDERFLOW;
            if (target.hasRemaining()) {
                if ((targetByteUnit & 0xFFFF) <= 255) {
                    target.put((byte)targetByteUnit);
                    if (offsets != null) {
                        offsets.put(source.position() - 1);
                    }
                } else {
                    target.put((byte)(targetByteUnit >> 8));
                    if (offsets != null) {
                        offsets.put(source.position() - 1);
                    }
                    if (target.hasRemaining()) {
                        target.put((byte)targetByteUnit);
                        if (offsets != null) {
                            offsets.put(source.position() - 1);
                        }
                    } else {
                        this.errorBuffer[this.errorBufferLength++] = (byte)targetByteUnit;
                        cr = CoderResult.OVERFLOW;
                    }
                }
            } else {
                if ((targetByteUnit & 0xFF00) > 0) {
                    this.errorBuffer[this.errorBufferLength++] = (byte)(targetByteUnit >> 8);
                }
                this.errorBuffer[this.errorBufferLength++] = (byte)targetByteUnit;
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }
    }

    class CharsetDecoderMacArabic
    extends CharsetDecoderICU {
        public CharsetDecoderMacArabic(CharsetICU cs) {
            super(cs);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            this.toUnicodeStatus = 65535;
            this.mode = 0;
        }

        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int targetUniChar = 0;
            short sourceChar = 0;
            int[] targetBegin = new int[1];
            int[] offsetsBegin = new int[1];
            UConverterDataMacArabic data = CharsetMacArabic.this.extraInfo;
            while (source.hasRemaining()) {
                if (target.hasRemaining()) {
                    sourceChar = (short)((short)source.get() & 0xFF);
                    targetUniChar = toUnicodeTable[sourceChar][0];
                    switch (toUnicodeTable[sourceChar][1]) {
                        case '\u0000': {
                            byte targetDirection = Character.getDirectionality((char)targetUniChar);
                            if (this.toUnicodeStatus != 65535) {
                                if (data.contextDirectionToUnicode == targetDirection) {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                } else {
                                    int directionTmp = data.contextDirectionToUnicode == '\u0000' ? 8237 : 8238;
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, directionTmp);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                                }
                            } else if (data.contextDirectionToUnicode == '\u202d' || data.contextDirectionToUnicode == '\u202e') {
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                            }
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                            if (targetDirection == 0 || targetDirection == 2) {
                                data.contextDirectionToUnicode = (char)targetDirection;
                                break;
                            }
                            data.contextDirectionToUnicode = (char)65534;
                            break;
                        }
                        case '\u202d': {
                            if (this.toUnicodeStatus != 65535) {
                                if (data.contextDirectionToUnicode == '\u0000') {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8237);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                } else {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8238);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8237);
                                }
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                                data.contextDirectionToUnicode = (char)8237;
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u0000') {
                                this.toUnicodeStatus = targetUniChar;
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u202d') {
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u202e') {
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                            }
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8237);
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                            data.contextDirectionToUnicode = (char)8237;
                            break;
                        }
                        case '\u202e': {
                            if (this.toUnicodeStatus != 65535) {
                                if (data.contextDirectionToUnicode == '\u0002') {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8238);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                } else {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8237);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8238);
                                }
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                                data.contextDirectionToUnicode = (char)8238;
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u0001') {
                                if (sourceChar < -80 || sourceChar > -71) {
                                    this.toUnicodeStatus = targetUniChar;
                                    break;
                                }
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8238);
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                                data.contextDirectionToUnicode = (char)8238;
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u202e') {
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u202d') {
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                            }
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8238);
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                            data.contextDirectionToUnicode = (char)8238;
                        }
                    }
                    continue;
                }
                cr = CoderResult.OVERFLOW;
                break;
            }
            if (!cr.isOverflow() && flush && !source.hasRemaining()) {
                if (this.toUnicodeStatus != 65535) {
                    int directionTmp = data.contextDirectionToUnicode == '\u0000' ? 8237 : 8238;
                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, directionTmp);
                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                } else if (data.contextDirectionToUnicode == '\u202d' || data.contextDirectionToUnicode == '\u202e') {
                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                }
            }
            return cr;
        }

        private CoderResult WriteToTargetToU(IntBuffer offsets, int offset, ByteBuffer source, CharBuffer target, int targetUniChar) {
            CoderResult cr = CoderResult.UNDERFLOW;
            if (target.hasRemaining()) {
                target.put((char)targetUniChar);
                if (offsets != null) {
                    offsets.put(offset);
                }
            } else {
                this.charErrorBufferArray[this.charErrorBufferLength++] = (char)targetUniChar;
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }
    }

    private static final class UConverterDataMacArabic {
        int option;
        char contextDirectionToUnicode;
        boolean isFirstBuffer = true;
        String name;
        int realSourceArrayIndex = -1;
        StringBuffer fromUPara = new StringBuffer();
        int paraIndex = 0;
        boolean isInParagraph = false;

        void initialize() {
            this.contextDirectionToUnicode = (char)65534;
            this.name = "MacArabic";
        }

        UConverterDataMacArabic() {
            this.initialize();
        }
    }
}

