/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.IOException;
import java.io.InputStream;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.net.SPDU;
import macromedia.sequelink.net.SPDUAccept;
import macromedia.sequelink.net.SPDUDecoder;

public class SPDUAcceptDecoder
extends SPDUDecoder {
    private int fuReq = 53;
    private int protocolOptions = 14;
    private byte[] callingSelector;
    private byte[] calledSelector;
    private int maxSendTduSize;
    private int maxRecvTduSize;
    private int userDataLen;
    private SPDUAccept spdu;

    SPDUAcceptDecoder(SPDU sPDU, InputStream inputStream) throws NetworkException {
        super(sPDU, inputStream);
        if (sPDU.getSpduType() != 2) {
            throw SPDU.getException(7571);
        }
        this.decodeParams();
        this.spdu = new SPDUAccept(this.fuReq, this.protocolOptions, this.callingSelector, this.calledSelector, this.maxSendTduSize, this.maxRecvTduSize, this.userDataLen);
    }

    public SPDUAccept getSPDUAccept() {
        return this.spdu;
    }

    private void decodeParams() throws NetworkException {
        boolean bl2 = false;
        block11: while (!bl2) {
            byte by2;
            try {
                by2 = this.dis.readByte();
            }
            catch (IOException iOException) {
                throw SPDU.getException(7578, iOException.getMessage());
            }
            switch (by2) {
                case 2: {
                    this.decodeProtocolOptions();
                    continue block11;
                }
                case 3: {
                    this.decodeFuReq();
                    continue block11;
                }
                case 4: {
                    this.decodeMaxTduSize();
                    continue block11;
                }
                case 5: {
                    this.decodeVersion();
                    continue block11;
                }
                case 7: {
                    this.decodeCallingSelector();
                    continue block11;
                }
                case 8: {
                    this.decodeCalledSelector();
                    continue block11;
                }
                case 9: {
                    this.decodeUserDataLen();
                    bl2 = true;
                    continue block11;
                }
            }
            throw SPDU.getException(7574);
        }
    }

    private void decodeVersion() throws NetworkException {
        byte by2;
        byte by3;
        try {
            by3 = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        if (by3 != 1) {
            throw SPDU.getException(7575);
        }
        try {
            by2 = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        if (by2 != 1) {
            throw SPDU.getException(7577);
        }
    }

    private void decodeProtocolOptions() throws NetworkException {
        byte by2;
        try {
            by2 = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        if (by2 != 1) {
            throw SPDU.getException(7575);
        }
        try {
            this.protocolOptions = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void decodeFuReq() throws NetworkException {
        short s2;
        byte by2;
        try {
            by2 = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        if (by2 != 2) {
            throw SPDU.getException(7575);
        }
        try {
            s2 = this.dis.readShort();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        this.fuReq = s2;
    }

    private void decodeMaxTduSize() throws NetworkException {
        byte by2;
        try {
            by2 = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        if (by2 != 8) {
            throw SPDU.getException(7575);
        }
        try {
            this.maxSendTduSize = this.dis.readInt();
            this.maxRecvTduSize = this.dis.readInt();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void decodeCallingSelector() throws NetworkException {
        try {
            byte by2 = this.dis.readByte();
            if (by2 != 0) {
                this.callingSelector = new byte[by2];
                this.dis.readFully(this.callingSelector);
            }
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void decodeCalledSelector() throws NetworkException {
        try {
            byte by2 = this.dis.readByte();
            if (by2 != 0) {
                this.calledSelector = new byte[by2];
                this.dis.readFully(this.calledSelector);
            }
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void decodeUserDataLen() throws NetworkException {
        try {
            this.userDataLen = this.dis.readShort();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        this.userDataLen = this.userDataLen;
    }
}

