/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbcx.sqlserver;

import java.net.Socket;
import java.net.SocketException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import macromedia.jdbc.sqlserver.SQLServerImplConnection;
import macromedia.jdbc.sqlserver.base.BaseConnection;
import macromedia.jdbc.sqlserver.base.BaseConnectionProperties;
import macromedia.jdbc.sqlserver.base.t;
import macromedia.jdbc.sqlserver.tds.e;
import macromedia.jdbc.sqlserver.util.UtilDebug;
import macromedia.jdbc.sqlserver.util.annotation.a;
import macromedia.jdbcx.sqlserver.SQLServerDataSource;
import macromedia.jdbcx.sqlserver.base.g;
import macromedia.jdbcx.sqlserver.base.r;

public final class SQLServerImplXAResource
extends g {
    private static String footprint = "$Revision$";
    static final short XA_OPEN = 0;
    static final short XA_CLOSE = 1;
    static final short XA_START = 2;
    static final short XA_END = 3;
    static final short XA_PREPARE = 4;
    static final short XA_COMMIT = 5;
    static final short XA_ROLLBACK = 6;
    static final short XA_FORGET = 7;
    static final short XA_RECOVER = 8;
    static final String[] XP_XA = new String[]{"exec ? = master..xp_jdbc_open2", "exec ? = master..xp_jdbc_close2", "exec ? = master..xp_jdbc_start2 ?, ?, ?, ?, ?", "exec ? = master..xp_jdbc_end2 ?, ?", "exec ? = master..xp_jdbc_prepare2 ?, ?", "exec ? = master..xp_jdbc_commit2 ?, ?", "exec ? = master..xp_jdbc_rollback2 ?, ?", "exec ? = master..xp_jdbc_forget2 ?, ?", "exec ? = master..xp_jdbc_recover2 ?, ?, ?"};
    CallableStatement[] callableStatements = new CallableStatement[XP_XA.length];
    BaseConnectionProperties connectProps;
    int timeout;
    SQLServerDataSource ds;
    BaseConnection txnConn;
    int nXids;
    byte[] xidBytes;
    byte[] cookie;
    boolean enlisted = false;
    boolean isServer7 = true;
    e request = null;
    SQLException sqlEx = null;
    boolean startedWithJoin = false;
    long transactionDescriptor;

    public SQLServerImplXAResource(SQLServerDataSource sQLServerDataSource, BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.connectProps = baseConnection.dR();
        this.ds = sQLServerDataSource;
        this.transactionDescriptor = 0L;
    }

    @Override
    protected boolean recoverReturnsAllXidsAtOnce() {
        return false;
    }

    @Override
    protected void open(int n2) throws SQLException {
        Socket socket = null;
        int n3 = 0;
        this.requiredLocalAutoCommit = 1;
        String string = t.c(this.toString(), "ImplXAResource");
        this.txnConn = t.E(string);
        BaseConnectionProperties baseConnectionProperties = this.connectProps.ec();
        baseConnectionProperties.put("initializationString", "");
        baseConnectionProperties.put("stringInputParameterType", "nvarchar");
        this.txnConn.a(baseConnectionProperties, t.mi.D(string), new UtilDebug());
        try {
            socket = this.txnConn.nw.bu();
            n3 = socket.getSoTimeout();
            socket.setSoTimeout(n2 * 1000);
            this.txnConn.setTransactionIsolation(2112);
            DatabaseMetaData databaseMetaData = this.txnConn.getMetaData();
            String string2 = databaseMetaData.getDatabaseProductVersion();
            this.isServer7 = false;
            if (string2.startsWith("Microsoft SQL Server  7.00")) {
                this.isServer7 = true;
            }
            this.request = ((SQLServerImplConnection)this.connection.nw).bd();
            for (int i2 = 0; i2 < XP_XA.length; ++i2) {
                this.callableStatements[i2] = this.txnConn.prepareCall(XP_XA[i2]);
            }
            this.executeXaRpc((short)0);
        }
        catch (SocketException socketException) {
        }
        catch (XAException xAException) {
            String string3 = this.exceptions.gd().a(6085, null, false);
            if (xAException.getMessage().equalsIgnoreCase(string3)) {
                throw this.exceptions.a(6049, "HYT00");
            }
            if (this.sqlEx != null) {
                throw this.sqlEx;
            }
            throw new SQLException(xAException.getMessage());
        }
        finally {
            try {
                if (socket != null) {
                    socket.setSoTimeout(n3);
                }
            }
            catch (SocketException socketException) {}
        }
    }

    @Override
    protected void close() throws SQLException {
        try {
            this.executeXaRpc((short)1);
        }
        catch (XAException xAException) {
            if (this.sqlEx != null) {
                throw this.sqlEx;
            }
            throw new SQLException(xAException.getMessage());
        }
        finally {
            try {
                for (int i2 = 0; i2 < XP_XA.length; ++i2) {
                    this.callableStatements[i2].close();
                }
                this.request = null;
                this.txnConn.close();
                this.txnConn = null;
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected void start(Xid xid, int n2) throws XAException {
        if (this.enlisted && n2 == 0) {
            XAException xAException = new XAException(this.exceptions.bo(7018).getMessage());
            xAException.errorCode = -6;
            throw xAException;
        }
        this.startedWithJoin = (n2 & 0x200000) != 0;
        this.executeXaRpc((short)2, xid, n2);
        this.enlist();
    }

    @Override
    protected void end(Xid xid, int n2) throws XAException {
        block6: {
            try {
                if (((SQLServerImplConnection)this.connection.nw).gp) {
                    this.enlisted = false;
                    try {
                        this.xaConnection.al(false);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.executeXaRpc((short)3, xid, n2);
                if (!this.isServer7) {
                    this.unenlist();
                }
            }
            catch (XAException xAException) {
                if (this.startedWithJoin && xAException.errorCode == -3) break block6;
                throw xAException;
            }
        }
    }

    @Override
    protected int prepare(Xid xid) throws XAException {
        int n2 = 0;
        int n3 = this.executeXaRpc((short)4, xid, n2);
        return n3;
    }

    @Override
    protected void commit(Xid xid, boolean bl2) throws XAException {
        int n2 = 0;
        if (bl2) {
            n2 = 0x40000000;
        }
        this.executeXaRpc((short)5, xid, n2);
        if (this.isServer7) {
            this.unenlist();
        }
    }

    @Override
    protected void rollback(Xid xid) throws XAException {
        int n2 = 0;
        this.executeXaRpc((short)6, xid, n2);
        if (this.isServer7) {
            this.unenlist();
        }
    }

    @Override
    protected void forget(Xid xid) throws XAException {
        int n2 = 0;
        this.executeXaRpc((short)7, xid, n2);
        if (this.isServer7) {
            this.unenlist();
        }
    }

    @Override
    protected Xid[] recover(int n2) throws XAException {
        this.executeXaRpc((short)8, null, n2);
        int n3 = 0;
        Xid[] xidArray = new r[this.nXids];
        for (int i2 = 0; i2 < this.nXids; ++i2) {
            int n4 = ((this.xidBytes[n3 + 0] & 0xFF) << 0) + ((this.xidBytes[n3 + 1] & 0xFF) << 8) + ((this.xidBytes[n3 + 2] & 0xFF) << 16) + ((this.xidBytes[n3 + 3] & 0xFF) << 24);
            byte by2 = this.xidBytes[n3 += 4];
            byte by3 = this.xidBytes[++n3];
            byte[] byArray = new byte[by2];
            byte[] byArray2 = new byte[by3];
            System.arraycopy(this.xidBytes, ++n3, byArray, 0, by2);
            System.arraycopy(this.xidBytes, n3 += by2, byArray2, 0, by3);
            n3 += by3;
            xidArray[i2] = new r(n4, byArray, byArray2);
        }
        return xidArray;
    }

    @Override
    protected boolean setTransactionTimeout(int n2) throws XAException {
        if (n2 < 0) {
            throw new XAException(-5);
        }
        this.timeout = n2;
        return true;
    }

    @Override
    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    protected String getRmIdentification() throws XAException {
        String string = this.connectProps.get("serverName");
        String string2 = this.connectProps.get("portNumber");
        String string3 = this.connectProps.get("databaseName");
        String string4 = string + "_" + string2 + "_" + string3;
        return string4;
    }

    private final int executeXaRpc(short s2) throws XAException {
        return this.executeXaRpc(s2, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @a(uq="alavinio", uo="vvalakon", um="2022-07-13", ul="89:generated-sql")
    private final int executeXaRpc(short var1_1, Xid var2_2, int var3_3) throws XAException {
        var4_4 = 0;
        var5_5 = null;
        this.sqlEx = null;
        try {
            var5_5 = this.callableStatements[var1_1];
            var5_5.registerOutParameter(1, 4);
            switch (var1_1) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    var5_5.registerOutParameter(4, -2);
                    var5_5.setInt(5, this.timeout);
                    if (this.connectProps.get("xaTransactionGroup") == null) {
                        var5_5.setNull(6, 12);
                    } else {
                        var5_5.setString(6, this.connectProps.get("xaTransactionGroup"));
                    }
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    var6_6 = this.getXidBytes(var2_2);
                    var5_5.setBytes(2, (byte[])var6_6);
                    var5_5.setInt(3, var3_3);
                    break;
                }
                case 8: {
                    var5_5.setInt(2, var3_3);
                    var5_5.registerOutParameter(3, -2);
                    if (this.connectProps.get("xaTransactionGroup") == null) {
                        var5_5.setNull(4, 12);
                        break;
                    }
                    var5_5.setString(4, this.connectProps.get("xaTransactionGroup"));
                }
            }
            var5_5.executeUpdate();
            var4_4 = var5_5.getInt(1);
            switch (var1_1) {
                case 2: {
                    this.cookie = var5_5.getBytes(4);
                    break;
                }
                case 8: {
                    this.nXids = var4_4;
                    this.xidBytes = var5_5.getBytes(3);
                }
            }
            ** if (this.sqlEx == null) goto lbl-1000
        }
        catch (SQLException var6_7) {
            try {
                this.sqlEx = var6_7;
                ** if (this.sqlEx == null) goto lbl-1000
            }
            catch (Throwable var9_13) {
                if (this.sqlEx != null) {
                    var10_14 = this.sqlEx.getMessage();
                    var11_15 = new XAException(var10_14);
                    var12_16 = var10_14.indexOf("returns");
                    var11_15.errorCode = var12_16 == -1 ? -3 : Integer.parseInt(var10_14.substring(var12_16 + 8));
                    throw var11_15;
                }
                throw var9_13;
            }
lbl-1000:
            // 1 sources

            {
                var6_8 = this.sqlEx.getMessage();
                var7_10 = new XAException(var6_8);
                var8_12 = var6_8.indexOf("returns");
                var7_10.errorCode = var8_12 == -1 ? -3 : Integer.parseInt(var6_8.substring(var8_12 + 8));
                throw var7_10;
            }
lbl-1000:
            // 1 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            var6_6 = this.sqlEx.getMessage();
            var7_9 = new XAException((String)var6_6);
            var8_11 = var6_6.indexOf("returns");
            var7_9.errorCode = var8_11 == -1 ? -3 : Integer.parseInt(var6_6.substring(var8_11 + 8));
            throw var7_9;
        }
lbl-1000:
        // 1 sources

        {
        }
        this.verifyReturnCode("", var4_4);
        return var4_4;
    }

    private final void verifyReturnCode(String string, int n2) throws XAException {
        if (n2 >= 0) {
            return;
        }
        XAException xAException = new XAException(string);
        xAException.errorCode = n2;
        throw xAException;
    }

    private byte[] getXidBytes(Xid xid) {
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = 6 + byArray.length + byArray2.length;
        byte[] byArray3 = new byte[n3];
        byArray3[0] = (byte)(n2 >>> 0 & 0xFF);
        byArray3[1] = (byte)(n2 >>> 8 & 0xFF);
        byArray3[2] = (byte)(n2 >>> 16 & 0xFF);
        byArray3[3] = (byte)(n2 >>> 24 & 0xFF);
        byArray3[4] = (byte)byArray.length;
        byArray3[5] = (byte)byArray2.length;
        System.arraycopy(byArray, 0, byArray3, 6, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 6 + byArray.length, byArray2.length);
        return byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enlist() throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            if (this.enlisted) {
                return;
            }
            try {
                int n2 = this.connection.getTransactionIsolation();
                this.request.v(this.cookie);
                if (n2 != 8) {
                    this.connection.setTransactionIsolation(n2);
                }
                this.enlisted = true;
                ((SQLServerImplConnection)this.connection.nw).gp = false;
                this.transactionDescriptor = ((SQLServerImplConnection)this.connection.nw).bw().transactionDescriptor;
            }
            catch (SQLException sQLException) {
                XAException xAException = new XAException(sQLException.getMessage());
                xAException.errorCode = -3;
                throw xAException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unenlist() throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.cL.d(this.transactionDescriptor);
                this.request.qS();
                this.enlisted = false;
                this.transactionDescriptor = 0L;
                ((SQLServerImplConnection)this.connection.nw).gp = true;
            }
            catch (SQLException sQLException) {
                XAException xAException = new XAException(sQLException.getMessage());
                xAException.errorCode = -3;
                throw xAException;
            }
        }
    }
}

