/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.org.reactivestreams;

import java.util.Objects;
import java.util.concurrent.Flow;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Processor;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Publisher;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Subscriber;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Subscription;

public final class FlowAdapters {
    private FlowAdapters() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Publisher<T> toPublisher(Flow.Publisher<? extends T> publisher) {
        Objects.requireNonNull(publisher, "flowPublisher");
        ReactivePublisherFromFlow<? extends T> reactivePublisherFromFlow = publisher instanceof FlowPublisherFromReactive ? ((FlowPublisherFromReactive)publisher).reactiveStreams : (publisher instanceof Publisher ? (ReactivePublisherFromFlow<? extends T>)((Object)publisher) : new ReactivePublisherFromFlow<T>(publisher));
        return reactivePublisherFromFlow;
    }

    public static <T> Flow.Publisher<T> toFlowPublisher(Publisher<? extends T> publisher) {
        Objects.requireNonNull(publisher, "reactiveStreamsPublisher");
        FlowPublisherFromReactive<? extends T> flowPublisherFromReactive = publisher instanceof ReactivePublisherFromFlow ? ((ReactivePublisherFromFlow)publisher).flow : (publisher instanceof Flow.Publisher ? (FlowPublisherFromReactive<? extends T>)((Object)publisher) : new FlowPublisherFromReactive<T>(publisher));
        return flowPublisherFromReactive;
    }

    public static <T, U> Processor<T, U> toProcessor(Flow.Processor<? super T, ? extends U> processor) {
        Objects.requireNonNull(processor, "flowProcessor");
        ReactiveToFlowProcessor<? super T, ? extends U> reactiveToFlowProcessor = processor instanceof FlowToReactiveProcessor ? ((FlowToReactiveProcessor)processor).reactiveStreams : (processor instanceof Processor ? (ReactiveToFlowProcessor<? super T, ? extends U>)((Object)processor) : new ReactiveToFlowProcessor<T, U>(processor));
        return reactiveToFlowProcessor;
    }

    public static <T, U> Flow.Processor<T, U> toFlowProcessor(Processor<? super T, ? extends U> processor) {
        Objects.requireNonNull(processor, "reactiveStreamsProcessor");
        FlowToReactiveProcessor<? super T, ? extends U> flowToReactiveProcessor = processor instanceof ReactiveToFlowProcessor ? ((ReactiveToFlowProcessor)processor).flow : (processor instanceof Flow.Processor ? (FlowToReactiveProcessor<? super T, ? extends U>)((Object)processor) : new FlowToReactiveProcessor<T, U>(processor));
        return flowToReactiveProcessor;
    }

    public static <T> Flow.Subscriber<T> toFlowSubscriber(Subscriber<T> subscriber) {
        Objects.requireNonNull(subscriber, "reactiveStreamsSubscriber");
        FlowToReactiveSubscriber<T> flowToReactiveSubscriber = subscriber instanceof ReactiveToFlowSubscriber ? ((ReactiveToFlowSubscriber)subscriber).flow : (subscriber instanceof Flow.Subscriber ? (FlowToReactiveSubscriber<T>)((Object)subscriber) : new FlowToReactiveSubscriber<T>(subscriber));
        return flowToReactiveSubscriber;
    }

    public static <T> Subscriber<T> toSubscriber(Flow.Subscriber<T> subscriber) {
        Objects.requireNonNull(subscriber, "flowSubscriber");
        ReactiveToFlowSubscriber<T> reactiveToFlowSubscriber = subscriber instanceof FlowToReactiveSubscriber ? ((FlowToReactiveSubscriber)subscriber).reactiveStreams : (subscriber instanceof Subscriber ? (ReactiveToFlowSubscriber<T>)((Object)subscriber) : new ReactiveToFlowSubscriber<T>(subscriber));
        return reactiveToFlowSubscriber;
    }

    static final class FlowPublisherFromReactive<T>
    implements Flow.Publisher<T> {
        final Publisher<? extends T> reactiveStreams;

        public FlowPublisherFromReactive(Publisher<? extends T> publisher) {
            this.reactiveStreams = publisher;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> subscriber) {
            this.reactiveStreams.subscribe(subscriber == null ? null : new ReactiveToFlowSubscriber<T>(subscriber));
        }
    }

    static final class ReactivePublisherFromFlow<T>
    implements Publisher<T> {
        final Flow.Publisher<? extends T> flow;

        public ReactivePublisherFromFlow(Flow.Publisher<? extends T> publisher) {
            this.flow = publisher;
        }

        @Override
        public void subscribe(Subscriber<? super T> subscriber) {
            this.flow.subscribe(subscriber == null ? null : new FlowToReactiveSubscriber<T>(subscriber));
        }
    }

    static final class FlowToReactiveProcessor<T, U>
    implements Flow.Processor<T, U> {
        final Processor<? super T, ? extends U> reactiveStreams;

        public FlowToReactiveProcessor(Processor<? super T, ? extends U> processor) {
            this.reactiveStreams = processor;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.reactiveStreams.onSubscribe(subscription == null ? null : new ReactiveToFlowSubscription(subscription));
        }

        @Override
        public void onNext(T t2) {
            this.reactiveStreams.onNext(t2);
        }

        @Override
        public void onError(Throwable throwable) {
            this.reactiveStreams.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.reactiveStreams.onComplete();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super U> subscriber) {
            this.reactiveStreams.subscribe(subscriber == null ? null : new ReactiveToFlowSubscriber<U>(subscriber));
        }
    }

    static final class ReactiveToFlowProcessor<T, U>
    implements Processor<T, U> {
        final Flow.Processor<? super T, ? extends U> flow;

        public ReactiveToFlowProcessor(Flow.Processor<? super T, ? extends U> processor) {
            this.flow = processor;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            this.flow.onSubscribe(subscription == null ? null : new FlowToReactiveSubscription(subscription));
        }

        @Override
        public void onNext(T t2) {
            this.flow.onNext(t2);
        }

        @Override
        public void onError(Throwable throwable) {
            this.flow.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.flow.onComplete();
        }

        @Override
        public void subscribe(Subscriber<? super U> subscriber) {
            this.flow.subscribe(subscriber == null ? null : new FlowToReactiveSubscriber<U>(subscriber));
        }
    }

    static final class ReactiveToFlowSubscriber<T>
    implements Subscriber<T> {
        final Flow.Subscriber<? super T> flow;

        public ReactiveToFlowSubscriber(Flow.Subscriber<? super T> subscriber) {
            this.flow = subscriber;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            this.flow.onSubscribe(subscription == null ? null : new FlowToReactiveSubscription(subscription));
        }

        @Override
        public void onNext(T t2) {
            this.flow.onNext(t2);
        }

        @Override
        public void onError(Throwable throwable) {
            this.flow.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.flow.onComplete();
        }
    }

    static final class FlowToReactiveSubscriber<T>
    implements Flow.Subscriber<T> {
        final Subscriber<? super T> reactiveStreams;

        public FlowToReactiveSubscriber(Subscriber<? super T> subscriber) {
            this.reactiveStreams = subscriber;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.reactiveStreams.onSubscribe(subscription == null ? null : new ReactiveToFlowSubscription(subscription));
        }

        @Override
        public void onNext(T t2) {
            this.reactiveStreams.onNext(t2);
        }

        @Override
        public void onError(Throwable throwable) {
            this.reactiveStreams.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.reactiveStreams.onComplete();
        }
    }

    static final class ReactiveToFlowSubscription
    implements Subscription {
        final Flow.Subscription flow;

        public ReactiveToFlowSubscription(Flow.Subscription subscription) {
            this.flow = subscription;
        }

        @Override
        public void request(long l2) {
            this.flow.request(l2);
        }

        @Override
        public void cancel() {
            this.flow.cancel();
        }
    }

    static final class FlowToReactiveSubscription
    implements Flow.Subscription {
        final Subscription reactiveStreams;

        public FlowToReactiveSubscription(Subscription subscription) {
            this.reactiveStreams = subscription;
        }

        @Override
        public void request(long l2) {
            this.reactiveStreams.request(l2);
        }

        @Override
        public void cancel() {
            this.reactiveStreams.cancel();
        }
    }
}

