/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.net.minidev.json.parser;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.parser.ParseException;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReader;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReaderI;

abstract class JSONParserBase {
    protected char c;
    public static final int MAX_DEPTH = 400;
    protected int depth = 0;
    JsonReader base;
    public static final byte EOI = 26;
    protected static final char MAX_STOP = '~';
    private String lastKey;
    protected static boolean[] stopAll = new boolean[126];
    protected static boolean[] stopArray = new boolean[126];
    protected static boolean[] stopKey = new boolean[126];
    protected static boolean[] stopValue = new boolean[126];
    protected static boolean[] stopX = new boolean[126];
    protected final MSB sb = new MSB(15);
    protected Object xo;
    protected String xs;
    protected int pos;
    protected final boolean acceptLeadinZero;
    protected final boolean acceptNaN;
    protected final boolean acceptNonQuote;
    protected final boolean acceptSimpleQuote;
    protected final boolean acceptUselessComma;
    protected final boolean checkTaillingData;
    protected final boolean checkTaillingSpace;
    protected final boolean ignoreControlChar;
    protected final boolean useHiPrecisionFloat;
    protected final boolean useIntegerStorage;
    protected final boolean reject127;
    protected final boolean unrestictBigDigit;
    protected final boolean limitJsonDepth;

    public JSONParserBase(int n2) {
        this.acceptNaN = (n2 & 4) > 0;
        this.acceptNonQuote = (n2 & 2) > 0;
        this.acceptSimpleQuote = (n2 & 1) > 0;
        this.ignoreControlChar = (n2 & 8) > 0;
        this.useIntegerStorage = (n2 & 0x10) > 0;
        this.acceptLeadinZero = (n2 & 0x20) > 0;
        this.acceptUselessComma = (n2 & 0x40) > 0;
        this.useHiPrecisionFloat = (n2 & 0x80) > 0;
        this.checkTaillingData = (n2 & 0x300) != 768;
        this.checkTaillingSpace = (n2 & 0x200) == 0;
        this.reject127 = (n2 & 0x400) > 0;
        this.unrestictBigDigit = (n2 & 0x800) > 0;
        this.limitJsonDepth = (n2 & 0x1000) > 0;
    }

    public void checkControleChar() throws ParseException {
        if (this.ignoreControlChar) {
            return;
        }
        int n2 = this.xs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = this.xs.charAt(i2);
            if (c2 < '\u0000') continue;
            if (c2 <= '\u001f') {
                throw new ParseException(this.pos + i2, 0, Character.valueOf(c2));
            }
            if (c2 != '\u007f' || !this.reject127) continue;
            throw new ParseException(this.pos + i2, 0, Character.valueOf(c2));
        }
    }

    public void checkLeadinZero() throws ParseException {
        int n2 = this.xs.length();
        if (n2 == 1) {
            return;
        }
        if (n2 == 2) {
            if (this.xs.equals("00")) {
                throw new ParseException(this.pos, 6, this.xs);
            }
            return;
        }
        char c2 = this.xs.charAt(0);
        char c3 = this.xs.charAt(1);
        if (c2 == '-') {
            char c4 = this.xs.charAt(2);
            if (c3 == '0' && c4 >= '0' && c4 <= '9') {
                throw new ParseException(this.pos, 6, this.xs);
            }
            return;
        }
        if (c2 == '0' && c3 >= '0' && c3 <= '9') {
            throw new ParseException(this.pos, 6, this.xs);
        }
    }

    protected Number extractFloat() throws ParseException {
        if (!this.acceptLeadinZero) {
            this.checkLeadinZero();
        }
        try {
            if (!this.useHiPrecisionFloat) {
                return Float.valueOf(Float.parseFloat(this.xs));
            }
            if (this.xs.length() > 18) {
                double d2;
                String string;
                if (!this.unrestictBigDigit && this.compareDoublePrecision(string = String.valueOf(d2 = Double.parseDouble(this.xs)), this.xs)) {
                    return d2;
                }
                return new BigDecimal(this.xs);
            }
            return Double.parseDouble(this.xs);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(this.pos, 1, this.xs);
        }
    }

    private boolean compareDoublePrecision(String string, String string2) {
        char[] cArray;
        char[] cArray2 = string.toCharArray();
        if (cArray2.length > (cArray = string2.toCharArray()).length) {
            return false;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < cArray2.length; ++i2) {
            if (cArray2[i2] < '0' || cArray2[i2] > '9') {
                if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                    return false;
                }
                if (cArray[++n2] != '+') continue;
                ++n2;
                continue;
            }
            if (cArray2[i2] != cArray[n2]) {
                return false;
            }
            ++n2;
        }
        return n2 == cArray.length;
    }

    protected <T> T parse(JsonReaderI<T> jsonReaderI) throws ParseException {
        T t2;
        this.pos = -1;
        try {
            this.read();
            t2 = this.readFirst(jsonReaderI);
            if (this.checkTaillingData) {
                if (!this.checkTaillingSpace) {
                    this.skipSpace();
                }
                if (this.c != '\u001a') {
                    throw new ParseException(this.pos - 1, 1, Character.valueOf(this.c));
                }
            }
        }
        catch (IOException iOException) {
            throw new ParseException(this.pos, (Throwable)iOException);
        }
        this.xs = null;
        this.xo = null;
        return t2;
    }

    protected Number parseNumber(String string) throws ParseException {
        boolean bl2;
        boolean bl3;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 19;
        if (string.charAt(0) == '-') {
            ++n2;
            ++n4;
            bl3 = true;
            if (!this.acceptLeadinZero && n3 >= 3 && string.charAt(1) == '0') {
                throw new ParseException(this.pos, 6, string);
            }
        } else {
            bl3 = false;
            if (!this.acceptLeadinZero && n3 >= 2 && string.charAt(0) == '0') {
                throw new ParseException(this.pos, 6, string);
            }
        }
        if (n3 < n4) {
            n4 = n3;
            bl2 = false;
        } else {
            if (n3 > n4) {
                return new BigInteger(string, 10);
            }
            n4 = n3 - 1;
            bl2 = true;
        }
        long l2 = 0L;
        while (n2 < n4) {
            l2 = l2 * 10L + (long)(48 - string.charAt(n2++));
        }
        if (bl2) {
            boolean bl4;
            if (l2 > -922337203685477580L) {
                bl4 = false;
            } else if (l2 < -922337203685477580L) {
                bl4 = true;
            } else if (bl3) {
                bl4 = string.charAt(n2) > '8';
            } else {
                boolean bl5 = bl4 = string.charAt(n2) > '7';
            }
            if (bl4) {
                return new BigInteger(string, 10);
            }
            l2 = l2 * 10L + (long)(48 - string.charAt(n2));
        }
        if (bl3) {
            if (this.useIntegerStorage && l2 >= Integer.MIN_VALUE) {
                return (int)l2;
            }
            return l2;
        }
        l2 = -l2;
        if (this.useIntegerStorage && l2 <= Integer.MAX_VALUE) {
            return (int)l2;
        }
        return l2;
    }

    protected abstract void read() throws IOException;

    protected <T> T readArray(JsonReaderI<T> jsonReaderI) throws ParseException, IOException {
        if (this.c != '[') {
            throw new RuntimeException("Internal Error");
        }
        if (this.limitJsonDepth && ++this.depth > 400) {
            throw new ParseException(this.pos, 7, Character.valueOf(this.c));
        }
        Object object = jsonReaderI.createArray();
        this.read();
        boolean bl2 = false;
        if (this.c == ',' && !this.acceptUselessComma) {
            throw new ParseException(this.pos, 0, Character.valueOf(this.c));
        }
        block7: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block7;
                }
                case ']': {
                    if (bl2 && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    --this.depth;
                    this.read();
                    return jsonReaderI.convert(object);
                }
                case ':': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case ',': {
                    if (bl2 && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    this.read();
                    bl2 = true;
                    continue block7;
                }
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, "EOF");
                }
            }
            jsonReaderI.addValue(object, this.readMain(jsonReaderI, stopArray));
            bl2 = false;
        }
    }

    protected <T> T readFirst(JsonReaderI<T> jsonReaderI) throws ParseException, IOException {
        block12: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block12;
                }
                case ':': 
                case ']': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '{': {
                    return this.readObject(jsonReaderI);
                }
                case '[': {
                    return this.readArray(jsonReaderI);
                }
                case '\"': 
                case '\'': {
                    this.readString();
                    return jsonReaderI.convert(this.xs);
                }
                case 'n': {
                    this.readNQString(stopX);
                    if ("null".equals(this.xs)) {
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return jsonReaderI.convert(this.xs);
                }
                case 'f': {
                    this.readNQString(stopX);
                    if ("false".equals(this.xs)) {
                        return jsonReaderI.convert(Boolean.FALSE);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return jsonReaderI.convert(this.xs);
                }
                case 't': {
                    this.readNQString(stopX);
                    if ("true".equals(this.xs)) {
                        return jsonReaderI.convert(Boolean.TRUE);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return jsonReaderI.convert(this.xs);
                }
                case 'N': {
                    this.readNQString(stopX);
                    if (!this.acceptNaN) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    if ("NaN".equals(this.xs)) {
                        return jsonReaderI.convert(Float.valueOf(Float.NaN));
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return jsonReaderI.convert(this.xs);
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.xo = this.readNumber(stopX);
                    return jsonReaderI.convert(this.xo);
                }
            }
            break;
        }
        this.readNQString(stopX);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        return jsonReaderI.convert(this.xs);
    }

    protected Object readMain(JsonReaderI<?> jsonReaderI, boolean[] blArray) throws ParseException, IOException {
        block12: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block12;
                }
                case ':': 
                case ']': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '{': {
                    return this.readObject(jsonReaderI.startObject(this.lastKey));
                }
                case '[': {
                    return this.readArray(jsonReaderI.startArray(this.lastKey));
                }
                case '\"': 
                case '\'': {
                    this.readString();
                    return this.xs;
                }
                case 'n': {
                    this.readNQString(blArray);
                    if ("null".equals(this.xs)) {
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return this.xs;
                }
                case 'f': {
                    this.readNQString(blArray);
                    if ("false".equals(this.xs)) {
                        return Boolean.FALSE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return this.xs;
                }
                case 't': {
                    this.readNQString(blArray);
                    if ("true".equals(this.xs)) {
                        return Boolean.TRUE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return this.xs;
                }
                case 'N': {
                    this.readNQString(blArray);
                    if (!this.acceptNaN) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    if ("NaN".equals(this.xs)) {
                        return Float.valueOf(Float.NaN);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return this.xs;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.readNumber(blArray);
                }
            }
            break;
        }
        this.readNQString(blArray);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        return this.xs;
    }

    protected abstract void readNoEnd() throws ParseException, IOException;

    protected abstract void readNQString(boolean[] var1) throws IOException;

    protected abstract Object readNumber(boolean[] var1) throws ParseException, IOException;

    protected <T> T readObject(JsonReaderI<T> jsonReaderI) throws ParseException, IOException {
        if (this.c != '{') {
            throw new RuntimeException("Internal Error");
        }
        if (this.limitJsonDepth && ++this.depth > 400) {
            throw new ParseException(this.pos, 7, Character.valueOf(this.c));
        }
        Object object = jsonReaderI.createObject();
        boolean bl2 = false;
        boolean bl3 = true;
        block6: while (true) {
            this.read();
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                case ':': 
                case '[': 
                case ']': 
                case '{': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '}': {
                    if (bl2 && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    --this.depth;
                    this.read();
                    return jsonReaderI.convert(object);
                }
                case ',': {
                    if (bl2 && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    bl2 = true;
                    bl3 = true;
                    continue block6;
                }
            }
            if (this.c == '\"' || this.c == '\'') {
                this.readString();
            } else {
                this.readNQString(stopKey);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
            }
            String string = this.xs;
            if (!bl3) {
                throw new ParseException(this.pos, 1, string);
            }
            this.skipSpace();
            if (this.c != ':') {
                if (this.c == '\u001a') {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                throw new ParseException(this.pos - 1, 0, Character.valueOf(this.c));
            }
            this.readNoEnd();
            this.lastKey = string;
            Object object2 = this.readMain(jsonReaderI, stopValue);
            jsonReaderI.setValue(object, string, object2);
            this.lastKey = null;
            this.skipSpace();
            if (this.c == '}') {
                --this.depth;
                this.read();
                return jsonReaderI.convert(object);
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos - 1, 3, null);
            }
            if (this.c != ',') break;
            bl2 = true;
            bl3 = true;
        }
        throw new ParseException(this.pos - 1, 1, Character.valueOf(this.c));
    }

    abstract void readS() throws IOException;

    protected abstract void readString() throws ParseException, IOException;

    protected void readString2() throws ParseException, IOException {
        char c2 = this.c;
        block20: while (true) {
            this.read();
            switch (this.c) {
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                case '\"': 
                case '\'': {
                    if (c2 == this.c) {
                        this.read();
                        this.xs = this.sb.toString();
                        return;
                    }
                    this.sb.append(this.c);
                    continue block20;
                }
                case '\\': {
                    this.read();
                    switch (this.c) {
                        case 't': {
                            this.sb.append('\t');
                            continue block20;
                        }
                        case 'n': {
                            this.sb.append('\n');
                            continue block20;
                        }
                        case 'r': {
                            this.sb.append('\r');
                            continue block20;
                        }
                        case 'f': {
                            this.sb.append('\f');
                            continue block20;
                        }
                        case 'b': {
                            this.sb.append('\b');
                            continue block20;
                        }
                        case '\\': {
                            this.sb.append('\\');
                            continue block20;
                        }
                        case '/': {
                            this.sb.append('/');
                            continue block20;
                        }
                        case '\'': {
                            this.sb.append('\'');
                            continue block20;
                        }
                        case '\"': {
                            this.sb.append('\"');
                            continue block20;
                        }
                        case 'u': {
                            this.sb.append(this.readUnicode(4));
                            continue block20;
                        }
                        case 'x': {
                            this.sb.append(this.readUnicode(2));
                            continue block20;
                        }
                    }
                    continue block20;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    if (this.ignoreControlChar) continue block20;
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '\u007f': {
                    if (this.ignoreControlChar) continue block20;
                    if (!this.reject127) break;
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
            }
            this.sb.append(this.c);
        }
    }

    protected char readUnicode(int n2) throws ParseException, IOException {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 *= 16;
            this.read();
            if (this.c <= '9' && this.c >= '0') {
                n3 += this.c - 48;
                continue;
            }
            if (this.c <= 'F' && this.c >= 'A') {
                n3 += this.c - 65 + 10;
                continue;
            }
            if (this.c >= 'a' && this.c <= 'f') {
                n3 += this.c - 97 + 10;
                continue;
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos, 3, "EOF");
            }
            throw new ParseException(this.pos, 4, Character.valueOf(this.c));
        }
        return (char)n3;
    }

    protected void skipDigits() throws IOException {
        while (this.c >= '0' && this.c <= '9') {
            this.readS();
        }
        return;
    }

    protected void skipNQString(boolean[] blArray) throws IOException {
        while (!(this.c == '\u001a' || this.c >= '\u0000' && this.c < '~' && blArray[this.c])) {
            this.readS();
        }
        return;
    }

    protected void skipSpace() throws IOException {
        while (this.c <= ' ' && this.c != '\u001a') {
            this.readS();
        }
        return;
    }

    static {
        JSONParserBase.stopKey[26] = true;
        JSONParserBase.stopKey[58] = true;
        JSONParserBase.stopValue[26] = true;
        JSONParserBase.stopValue[125] = true;
        JSONParserBase.stopValue[44] = true;
        JSONParserBase.stopArray[26] = true;
        JSONParserBase.stopArray[93] = true;
        JSONParserBase.stopArray[44] = true;
        JSONParserBase.stopX[26] = true;
        JSONParserBase.stopAll[58] = true;
        JSONParserBase.stopAll[44] = true;
        JSONParserBase.stopAll[26] = true;
        JSONParserBase.stopAll[125] = true;
        JSONParserBase.stopAll[93] = true;
    }

    public static class MSB {
        char[] b;
        int p;

        public MSB(int n2) {
            this.b = new char[n2];
            this.p = -1;
        }

        public void append(char c2) {
            ++this.p;
            if (this.b.length <= this.p) {
                char[] cArray = new char[this.b.length * 2 + 1];
                System.arraycopy(this.b, 0, cArray, 0, this.b.length);
                this.b = cArray;
            }
            this.b[this.p] = c2;
        }

        public void append(int n2) {
            ++this.p;
            if (this.b.length <= this.p) {
                char[] cArray = new char[this.b.length * 2 + 1];
                System.arraycopy(this.b, 0, cArray, 0, this.b.length);
                this.b = cArray;
            }
            this.b[this.p] = (char)n2;
        }

        public String toString() {
            return new String(this.b, 0, this.p + 1);
        }

        public void clear() {
            this.p = -1;
        }
    }
}

