/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.ImmutableSecret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.RemoteJWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEDecryptionKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSVerificationKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.EncryptedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.PlainJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.ClockSkewAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.DefaultJWTProcessor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GeneralException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Nonce;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators.AbstractJWTValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.validators.IDTokenClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class IDTokenValidator
extends AbstractJWTValidator
implements ClockSkewAware {
    public IDTokenValidator(Issuer issuer, ClientID clientID) {
        this(issuer, clientID, (JWSKeySelector)null, null);
    }

    public IDTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, JWKSet jWKSet) {
        this(issuer, clientID, new JWSVerificationKeySelector(jWSAlgorithm, new ImmutableJWKSet(jWKSet)), null);
    }

    public IDTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, URL uRL) {
        this(issuer, clientID, jWSAlgorithm, uRL, null);
    }

    public IDTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, URL uRL, ResourceRetriever resourceRetriever) {
        this(issuer, clientID, new JWSVerificationKeySelector(jWSAlgorithm, new RemoteJWKSet(uRL, resourceRetriever)), null);
    }

    public IDTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, Secret secret) {
        this(issuer, clientID, new JWSVerificationKeySelector(jWSAlgorithm, new ImmutableSecret(secret.getValueBytes())), null);
    }

    public IDTokenValidator(Issuer issuer, ClientID clientID, JWSKeySelector jWSKeySelector, JWEKeySelector jWEKeySelector) {
        this(null, issuer, clientID, jWSKeySelector, jWEKeySelector);
    }

    public IDTokenValidator(JOSEObjectType jOSEObjectType, Issuer issuer, ClientID clientID, JWSKeySelector jWSKeySelector, JWEKeySelector jWEKeySelector) {
        super(jOSEObjectType, issuer, clientID, jWSKeySelector, jWEKeySelector);
    }

    public IDTokenClaimsSet validate(JWT jWT, Nonce nonce) throws BadJOSEException, JOSEException {
        if (jWT instanceof PlainJWT) {
            return this.validate((PlainJWT)jWT, nonce);
        }
        if (jWT instanceof SignedJWT) {
            return this.validate((SignedJWT)jWT, nonce);
        }
        if (jWT instanceof EncryptedJWT) {
            return this.validate((EncryptedJWT)jWT, nonce);
        }
        throw new JOSEException("Unexpected JWT type: " + jWT.getClass());
    }

    private IDTokenClaimsSet validate(PlainJWT plainJWT, Nonce nonce) throws BadJOSEException, JOSEException {
        JWTClaimsSet jWTClaimsSet;
        if (this.getJWSKeySelector() != null) {
            throw new BadJWTException("Signed ID token expected");
        }
        try {
            jWTClaimsSet = plainJWT.getJWTClaimsSet();
        }
        catch (java.text.ParseException parseException) {
            throw new BadJWTException(parseException.getMessage(), parseException);
        }
        IDTokenClaimsVerifier iDTokenClaimsVerifier = new IDTokenClaimsVerifier(this.getExpectedIssuer(), this.getClientID(), nonce, this.getMaxClockSkew());
        iDTokenClaimsVerifier.verify(jWTClaimsSet, null);
        return IDTokenValidator.toIDTokenClaimsSet(jWTClaimsSet);
    }

    private IDTokenClaimsSet validate(SignedJWT signedJWT, Nonce nonce) throws BadJOSEException, JOSEException {
        if (this.getJWSKeySelector() == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        if (this.getExpectedJWTType() != null) {
            defaultJWTProcessor.setJWSTypeVerifier(new DefaultJOSEObjectTypeVerifier(Collections.singleton(this.getExpectedJWTType())));
        }
        defaultJWTProcessor.setJWSKeySelector(this.getJWSKeySelector());
        defaultJWTProcessor.setJWTClaimsSetVerifier(new IDTokenClaimsVerifier(this.getExpectedIssuer(), this.getClientID(), nonce, this.getMaxClockSkew()));
        JWTClaimsSet jWTClaimsSet = defaultJWTProcessor.process(signedJWT, null);
        return IDTokenValidator.toIDTokenClaimsSet(jWTClaimsSet);
    }

    private IDTokenClaimsSet validate(EncryptedJWT encryptedJWT, Nonce nonce) throws BadJOSEException, JOSEException {
        if (this.getJWEKeySelector() == null) {
            throw new BadJWTException("Decryption of JWTs not configured");
        }
        if (this.getJWSKeySelector() == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        defaultJWTProcessor.setJWSKeySelector(this.getJWSKeySelector());
        defaultJWTProcessor.setJWEKeySelector(this.getJWEKeySelector());
        defaultJWTProcessor.setJWTClaimsSetVerifier(new IDTokenClaimsVerifier(this.getExpectedIssuer(), this.getClientID(), nonce, this.getMaxClockSkew()));
        JWTClaimsSet jWTClaimsSet = defaultJWTProcessor.process(encryptedJWT, null);
        return IDTokenValidator.toIDTokenClaimsSet(jWTClaimsSet);
    }

    private static IDTokenClaimsSet toIDTokenClaimsSet(JWTClaimsSet jWTClaimsSet) throws JOSEException {
        try {
            return new IDTokenClaimsSet(jWTClaimsSet);
        }
        catch (ParseException parseException) {
            throw new JOSEException(parseException.getMessage(), parseException);
        }
    }

    protected static JWSKeySelector createJWSKeySelector(OIDCProviderMetadata oIDCProviderMetadata, OIDCClientInformation oIDCClientInformation) throws GeneralException {
        JWSAlgorithm jWSAlgorithm = oIDCClientInformation.getOIDCMetadata().getIDTokenJWSAlg();
        if (oIDCProviderMetadata.getIDTokenJWSAlgs() == null) {
            throw new GeneralException("Missing OpenID Provider id_token_signing_alg_values_supported parameter");
        }
        if (!oIDCProviderMetadata.getIDTokenJWSAlgs().contains(jWSAlgorithm)) {
            throw new GeneralException("The OpenID Provider doesn't support " + jWSAlgorithm + " ID tokens");
        }
        if (Algorithm.NONE.equals(jWSAlgorithm)) {
            return null;
        }
        if (JWSAlgorithm.Family.RSA.contains(jWSAlgorithm) || JWSAlgorithm.Family.EC.contains(jWSAlgorithm)) {
            URL uRL;
            try {
                uRL = oIDCProviderMetadata.getJWKSetURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new GeneralException("Invalid jwk set URI: " + malformedURLException.getMessage(), malformedURLException);
            }
            RemoteJWKSet remoteJWKSet = new RemoteJWKSet(uRL);
            return new JWSVerificationKeySelector(jWSAlgorithm, remoteJWKSet);
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains(jWSAlgorithm)) {
            Secret secret = oIDCClientInformation.getSecret();
            if (secret == null) {
                throw new GeneralException("Missing client secret");
            }
            return new JWSVerificationKeySelector(jWSAlgorithm, new ImmutableSecret(secret.getValueBytes()));
        }
        throw new GeneralException("Unsupported JWS algorithm: " + jWSAlgorithm);
    }

    protected static JWEKeySelector createJWEKeySelector(OIDCProviderMetadata oIDCProviderMetadata, OIDCClientInformation oIDCClientInformation, JWKSource jWKSource) throws GeneralException {
        JWEAlgorithm jWEAlgorithm = oIDCClientInformation.getOIDCMetadata().getIDTokenJWEAlg();
        EncryptionMethod encryptionMethod = oIDCClientInformation.getOIDCMetadata().getIDTokenJWEEnc();
        if (jWEAlgorithm == null) {
            return null;
        }
        if (encryptionMethod == null) {
            throw new GeneralException("Missing required ID token JWE encryption method for " + jWEAlgorithm);
        }
        if (oIDCProviderMetadata.getIDTokenJWEAlgs() == null || !oIDCProviderMetadata.getIDTokenJWEAlgs().contains(jWEAlgorithm)) {
            throw new GeneralException("The OpenID Provider doesn't support " + jWEAlgorithm + " ID tokens");
        }
        if (oIDCProviderMetadata.getIDTokenJWEEncs() == null || !oIDCProviderMetadata.getIDTokenJWEEncs().contains(encryptionMethod)) {
            throw new GeneralException("The OpenID Provider doesn't support " + jWEAlgorithm + " / " + encryptionMethod + " ID tokens");
        }
        return new JWEDecryptionKeySelector(jWEAlgorithm, encryptionMethod, jWKSource);
    }

    public static IDTokenValidator create(OIDCProviderMetadata oIDCProviderMetadata, OIDCClientInformation oIDCClientInformation, JWKSource jWKSource) throws GeneralException {
        JWSKeySelector jWSKeySelector = IDTokenValidator.createJWSKeySelector(oIDCProviderMetadata, oIDCClientInformation);
        JWEKeySelector jWEKeySelector = IDTokenValidator.createJWEKeySelector(oIDCProviderMetadata, oIDCClientInformation, jWKSource);
        return new IDTokenValidator(oIDCProviderMetadata.getIssuer(), oIDCClientInformation.getID(), jWSKeySelector, jWEKeySelector);
    }

    public static IDTokenValidator create(OIDCProviderMetadata oIDCProviderMetadata, OIDCClientInformation oIDCClientInformation) throws GeneralException {
        return IDTokenValidator.create(oIDCProviderMetadata, oIDCClientInformation, null);
    }

    public static IDTokenValidator create(Issuer issuer, OIDCClientInformation oIDCClientInformation) throws GeneralException, IOException {
        return IDTokenValidator.create(issuer, oIDCClientInformation, null, 0, 0);
    }

    public static IDTokenValidator create(Issuer issuer, OIDCClientInformation oIDCClientInformation, JWKSource jWKSource, int n2, int n3) throws GeneralException, IOException {
        OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.resolve(issuer, n2, n3);
        return IDTokenValidator.create(oIDCProviderMetadata, oIDCClientInformation, jWKSource);
    }
}

