/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.statement;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.RemoteKeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.RemoteJWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSVerificationKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.DefaultResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.DefaultJWTProcessor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.statement.InvalidSoftwareStatementException;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@ThreadSafe
public class SoftwareStatementProcessor<C extends SecurityContext> {
    private final boolean required;
    private final DefaultJWTProcessor<C> processor;

    public SoftwareStatementProcessor(Issuer issuer, boolean bl2, Set<JWSAlgorithm> set, JWKSet jWKSet) {
        this(issuer, bl2, set, new ImmutableJWKSet(jWKSet));
    }

    public SoftwareStatementProcessor(Issuer issuer, boolean bl2, Set<JWSAlgorithm> set, URL uRL, int n2, int n3, int n4) {
        this(issuer, bl2, set, new RemoteJWKSet(uRL, new DefaultResourceRetriever(n2, n3, n4)));
    }

    public SoftwareStatementProcessor(Issuer issuer, boolean bl2, Set<JWSAlgorithm> set, JWKSource<C> jWKSource) {
        this(issuer, bl2, set, jWKSource, Collections.emptySet());
    }

    public SoftwareStatementProcessor(Issuer issuer, boolean bl2, Set<JWSAlgorithm> set, JWKSource<C> jWKSource, Set<String> set2) {
        this.required = bl2;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("iss");
        if (CollectionUtils.isNotEmpty(set2)) {
            hashSet.addAll(set2);
        }
        this.processor = new DefaultJWTProcessor();
        this.processor.setJWSKeySelector(new JWSVerificationKeySelector<C>(set, jWKSource));
        this.processor.setJWTClaimsSetVerifier(new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(issuer.getValue()).build(), hashSet));
    }

    public OIDCClientMetadata process(OIDCClientMetadata oIDCClientMetadata) throws InvalidSoftwareStatementException, JOSEException {
        return this.process(oIDCClientMetadata, null);
    }

    public OIDCClientMetadata process(OIDCClientMetadata oIDCClientMetadata, C c2) throws InvalidSoftwareStatementException, JOSEException {
        JWTClaimsSet jWTClaimsSet;
        SignedJWT signedJWT = oIDCClientMetadata.getSoftwareStatement();
        if (signedJWT == null) {
            if (this.required) {
                throw new InvalidSoftwareStatementException("Missing required software statement");
            }
            return oIDCClientMetadata;
        }
        try {
            jWTClaimsSet = this.processor.process(signedJWT, c2);
        }
        catch (BadJOSEException badJOSEException) {
            throw new InvalidSoftwareStatementException("Invalid software statement JWT: " + badJOSEException.getMessage(), badJOSEException);
        }
        catch (RemoteKeySourceException remoteKeySourceException) {
            throw new InvalidSoftwareStatementException("Software statement JWT validation failed: " + remoteKeySourceException.getMessage(), remoteKeySourceException);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.putAll(oIDCClientMetadata.toJSONObject());
        jSONObject.remove("software_statement");
        JSONObject jSONObject2 = JSONObjectUtils.toJSONObject(jWTClaimsSet);
        jSONObject2.remove("iss");
        jSONObject.putAll(jSONObject2);
        try {
            return OIDCClientMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            throw new InvalidSoftwareStatementException("Error merging software statement: " + parseException.getMessage(), parseException);
        }
    }
}

