/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.id;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.id.PairwiseSubjectCodec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.id.SectorID;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class HashBasedPairwiseSubjectCodec
extends PairwiseSubjectCodec {
    public static final String HASH_ALGORITHM = "SHA-256";

    public HashBasedPairwiseSubjectCodec(byte[] byArray) {
        super(byArray);
        if (byArray == null) {
            throw new IllegalArgumentException("The salt must not be null");
        }
    }

    public HashBasedPairwiseSubjectCodec(Base64URL base64URL) {
        super(base64URL.decode());
    }

    @Override
    public Subject encode(SectorID sectorID, Subject subject) {
        MessageDigest messageDigest;
        try {
            messageDigest = this.getProvider() != null ? MessageDigest.getInstance(HASH_ALGORITHM, this.getProvider()) : MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        messageDigest.update(sectorID.getValue().getBytes(CHARSET));
        messageDigest.update(subject.getValue().getBytes(CHARSET));
        byte[] byArray = messageDigest.digest(this.getSalt());
        return new Subject(Base64URL.encode(byArray).toString());
    }
}

