/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.marks;

import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class TrustMarkEntry
implements Map.Entry<Identifier, SignedJWT> {
    private final Identifier id;
    private final SignedJWT trustMark;

    public TrustMarkEntry(Identifier identifier, SignedJWT signedJWT) {
        Objects.requireNonNull(identifier);
        this.id = identifier;
        Objects.requireNonNull(signedJWT);
        if (JWSObject.State.UNSIGNED.equals((Object)signedJWT.getState())) {
            throw new IllegalArgumentException("The trust mark must be in a signed state");
        }
        this.trustMark = signedJWT;
    }

    public Identifier getID() {
        return this.id;
    }

    public SignedJWT getTrustMark() {
        return this.trustMark;
    }

    @Override
    public Identifier getKey() {
        return this.getID();
    }

    @Override
    public SignedJWT getValue() {
        return this.getTrustMark();
    }

    @Override
    public SignedJWT setValue(SignedJWT signedJWT) {
        throw new UnsupportedOperationException();
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.getID().getValue());
        jSONObject.put("trust_mark", this.getTrustMark().serialize());
        return jSONObject;
    }

    public static TrustMarkEntry parse(JSONObject jSONObject) throws ParseException {
        String string = JSONObjectUtils.getString(jSONObject, "id");
        String string2 = JSONObjectUtils.getString(jSONObject, "trust_mark");
        try {
            return new TrustMarkEntry(new Identifier(string), SignedJWT.parse(string2));
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage(), parseException);
        }
    }
}

