/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class LeafEntityTypeConstraint {
    public static final LeafEntityTypeConstraint ANY = new LeafEntityTypeConstraint(null);
    private final Set<EntityType> allowed;

    public LeafEntityTypeConstraint(Set<EntityType> set) {
        this.allowed = CollectionUtils.isNotEmpty(set) ? set : null;
    }

    public boolean allowsAny() {
        return CollectionUtils.isEmpty(this.allowed);
    }

    public Set<EntityType> getAllowed() {
        return this.allowed;
    }

    public List<String> getAllowedAsStringList() {
        if (this.allowsAny()) {
            return null;
        }
        return Identifier.toStringList(this.allowed);
    }

    public boolean isAllowed(EntityType entityType) {
        return this.allowsAny() || this.allowed.contains(entityType);
    }

    public String toString() {
        if (this.allowsAny()) {
            return "null";
        }
        return this.allowed.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LeafEntityTypeConstraint)) {
            return false;
        }
        LeafEntityTypeConstraint leafEntityTypeConstraint = (LeafEntityTypeConstraint)object;
        return Objects.equals(this.getAllowed(), leafEntityTypeConstraint.getAllowed());
    }

    public int hashCode() {
        return Objects.hash(this.getAllowed());
    }

    public static LeafEntityTypeConstraint parse(List<String> list) throws ParseException {
        if (CollectionUtils.isEmpty(list)) {
            return ANY;
        }
        HashSet<EntityType> hashSet = new HashSet<EntityType>();
        for (String string : list) {
            hashSet.add(new EntityType(string));
        }
        return new LeafEntityTypeConstraint(hashSet);
    }
}

