/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust;

import java.security.ProviderException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.ListUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicyEntry;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationCombinationValidator;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class TrustChain {
    private final EntityStatement leaf;
    private final List<EntityStatement> superiors;
    private final EntityStatement trustAnchor;
    private Date exp;

    public TrustChain(EntityStatement entityStatement, List<EntityStatement> list) {
        this(entityStatement, list, null);
    }

    public TrustChain(EntityStatement entityStatement, List<EntityStatement> list, EntityStatement entityStatement2) {
        if (entityStatement == null) {
            throw new IllegalArgumentException("The leaf entity configuration must not be null");
        }
        if (!entityStatement.getClaimsSet().isSelfStatement()) {
            throw new IllegalArgumentException("The leaf entity configuration must be a self-statement");
        }
        this.leaf = entityStatement;
        if (CollectionUtils.isEmpty(list)) {
            throw new IllegalArgumentException("There must be at least one superior statement (issued by the trust anchor)");
        }
        this.superiors = list;
        this.trustAnchor = entityStatement2;
        if (entityStatement2 != null && !entityStatement2.getClaimsSet().isSelfStatement()) {
            throw new IllegalArgumentException("The trust anchor entity configuration must be a self-statement");
        }
        if (!TrustChain.hasValidIssuerSubjectChain(entityStatement, list, entityStatement2)) {
            throw new IllegalArgumentException("Broken subject - issuer chain");
        }
    }

    private static boolean hasValidIssuerSubjectChain(EntityStatement entityStatement, List<EntityStatement> list, EntityStatement entityStatement2) {
        Subject subject = entityStatement.getClaimsSet().getSubject();
        for (EntityStatement entityStatement3 : list) {
            if (!subject.equals(entityStatement3.getClaimsSet().getSubject())) {
                return false;
            }
            subject = new Subject(entityStatement3.getClaimsSet().getIssuer().getValue());
        }
        if (entityStatement2 == null) {
            return true;
        }
        EntityStatement entityStatement4 = list.get(list.size() - 1);
        return entityStatement4.getClaimsSet().getIssuer().equals(entityStatement2.getClaimsSet().getIssuer());
    }

    public EntityStatement getLeafConfiguration() {
        return this.leaf;
    }

    public List<EntityStatement> getSuperiorStatements() {
        return this.superiors;
    }

    public EntityStatement getTrustAnchorConfiguration() {
        return this.trustAnchor;
    }

    public EntityID getTrustAnchorEntityID() {
        return this.getSuperiorStatements().get(this.getSuperiorStatements().size() - 1).getClaimsSet().getIssuerEntityID();
    }

    public int length() {
        return this.getSuperiorStatements().size();
    }

    public MetadataPolicy resolveCombinedMetadataPolicy(EntityType entityType) throws PolicyViolationException {
        return this.resolveCombinedMetadataPolicy(entityType, MetadataPolicyEntry.DEFAULT_POLICY_COMBINATION_VALIDATOR);
    }

    public MetadataPolicy resolveCombinedMetadataPolicy(EntityType entityType, PolicyOperationCombinationValidator policyOperationCombinationValidator) throws PolicyViolationException {
        LinkedList<MetadataPolicy> linkedList = new LinkedList<MetadataPolicy>();
        for (EntityStatement entityStatement : this.getSuperiorStatements()) {
            MetadataPolicy metadataPolicy = entityStatement.getClaimsSet().getMetadataPolicy(entityType);
            if (metadataPolicy == null) continue;
            linkedList.add(metadataPolicy);
        }
        return MetadataPolicy.combine(linkedList, policyOperationCombinationValidator);
    }

    public Iterator<EntityStatement> iteratorFromLeaf() {
        final AtomicReference<EntityStatement> atomicReference = new AtomicReference<EntityStatement>(this.leaf);
        final Iterator<EntityStatement> iterator = this.superiors.iterator();
        return new Iterator<EntityStatement>(){

            @Override
            public boolean hasNext() {
                return atomicReference.get() != null;
            }

            @Override
            public EntityStatement next() {
                EntityStatement entityStatement = (EntityStatement)atomicReference.get();
                if (entityStatement == null) {
                    return null;
                }
                if (entityStatement.equals(TrustChain.this.leaf)) {
                    atomicReference.set(iterator.next());
                } else if (iterator.hasNext()) {
                    atomicReference.set(iterator.next());
                } else {
                    atomicReference.set(null);
                }
                return entityStatement;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Date resolveExpirationTime() {
        if (this.exp != null) {
            return this.exp;
        }
        Iterator<EntityStatement> iterator = this.iteratorFromLeaf();
        Date date = null;
        while (iterator.hasNext()) {
            Date date2 = iterator.next().getClaimsSet().getExpirationTime();
            if (date == null) {
                date = date2;
                continue;
            }
            if (!date2.before(date)) continue;
            date = date2;
        }
        this.exp = date;
        return this.exp;
    }

    public void verifySignatures(JWKSet jWKSet) throws BadJOSEException, JOSEException {
        Base64URL base64URL;
        try {
            base64URL = this.leaf.verifySignatureOfSelfStatement();
        }
        catch (BadJOSEException badJOSEException) {
            throw new BadJOSEException("Invalid leaf entity configuration: " + badJOSEException.getMessage(), badJOSEException);
        }
        for (int i2 = 0; i2 < this.superiors.size(); ++i2) {
            EntityStatement entityStatement = this.superiors.get(i2);
            JWKSet jWKSet2 = i2 + 1 == this.superiors.size() ? jWKSet : this.superiors.get(i2 + 1).getClaimsSet().getJWKSet();
            if (!TrustChain.hasJWKWithThumbprint(entityStatement.getClaimsSet().getJWKSet(), base64URL)) {
                throw new BadJOSEException("Signing JWK with thumbprint " + base64URL + " not found in entity statement issued from superior " + entityStatement.getClaimsSet().getIssuerEntityID());
            }
            try {
                base64URL = entityStatement.verifySignature(jWKSet2);
                continue;
            }
            catch (BadJOSEException badJOSEException) {
                throw new BadJOSEException("Invalid statement from " + entityStatement.getClaimsSet().getIssuer() + ": " + badJOSEException.getMessage(), badJOSEException);
            }
        }
        if (this.trustAnchor != null) {
            if (!TrustChain.hasJWKWithThumbprint(this.trustAnchor.getClaimsSet().getJWKSet(), base64URL)) {
                throw new BadJOSEException("Signing JWK with thumbprint " + base64URL + " not found in trust anchor entity configuration");
            }
            try {
                this.trustAnchor.verifySignatureOfSelfStatement();
            }
            catch (BadJOSEException badJOSEException) {
                throw new BadJOSEException("Invalid trust anchor entity configuration: " + badJOSEException.getMessage(), badJOSEException);
            }
        }
    }

    private static boolean hasJWKWithThumbprint(JWKSet jWKSet, Base64URL base64URL) {
        if (jWKSet == null) {
            return false;
        }
        for (JWK jWK : jWKSet.getKeys()) {
            try {
                if (!base64URL.equals(jWK.computeThumbprint())) continue;
                return true;
            }
            catch (JOSEException jOSEException) {
                throw new ProviderException(jOSEException.getMessage(), jOSEException);
            }
        }
        return false;
    }

    public List<SignedJWT> toJWTs() {
        LinkedList<SignedJWT> linkedList = new LinkedList<SignedJWT>();
        linkedList.add(this.leaf.getSignedStatement());
        for (EntityStatement entityStatement : this.superiors) {
            linkedList.add(entityStatement.getSignedStatement());
        }
        if (this.trustAnchor != null) {
            linkedList.add(this.trustAnchor.getSignedStatement());
        }
        return linkedList;
    }

    public List<String> toSerializedJWTs() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (SignedJWT signedJWT : this.toJWTs()) {
            linkedList.add(signedJWT.serialize());
        }
        return linkedList;
    }

    public static TrustChain parse(List<SignedJWT> list) throws ParseException {
        if (list.size() < 2) {
            throw new ParseException("There must be at least 2 statement JWTs");
        }
        EntityStatement entityStatement = null;
        LinkedList<EntityStatement> linkedList = new LinkedList<EntityStatement>();
        EntityStatement entityStatement2 = null;
        for (SignedJWT signedJWT : ListUtils.removeNullItems(list)) {
            EntityStatement entityStatement3;
            if (entityStatement == null) {
                try {
                    entityStatement = EntityStatement.parse(signedJWT);
                    continue;
                }
                catch (ParseException parseException) {
                    throw new ParseException("Invalid leaf entity configuration: " + parseException.getMessage(), parseException);
                }
            }
            try {
                entityStatement3 = EntityStatement.parse(signedJWT);
            }
            catch (ParseException parseException) {
                throw new ParseException("Invalid superior entity statement: " + parseException.getMessage(), parseException);
            }
            if (!entityStatement3.getClaimsSet().isSelfStatement()) {
                linkedList.add(entityStatement3);
                continue;
            }
            entityStatement2 = entityStatement3;
        }
        try {
            return new TrustChain(entityStatement, linkedList, entityStatement2);
        }
        catch (Exception exception) {
            throw new ParseException("Illegal trust chain: " + exception.getMessage(), exception);
        }
    }

    public static TrustChain parseSerialized(List<String> list) throws ParseException {
        LinkedList<SignedJWT> linkedList = new LinkedList<SignedJWT>();
        for (String string : ListUtils.removeNullItems(list)) {
            try {
                linkedList.add(SignedJWT.parse(string));
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid JWT in trust chain: " + parseException.getMessage(), parseException);
            }
        }
        return TrustChain.parse(linkedList);
    }
}

