/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.WellKnownPathComposeStrategy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequestSender;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FetchEntityStatementRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FetchEntityStatementResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.config.FederationEntityConfigurationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.config.FederationEntityConfigurationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.EntityStatementRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.ResolveException;

public class DefaultEntityStatementRetriever
implements EntityStatementRetriever {
    private final int httpConnectTimeoutMs;
    private final int httpReadTimeoutMs;
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT_MS = 1000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT_MS = 1000;
    private final HTTPRequestSender httpRequestSender;
    private final List<URI> recordedRequests = new LinkedList<URI>();

    public DefaultEntityStatementRetriever() {
        this(1000, 1000);
    }

    public DefaultEntityStatementRetriever(int n2, int n3) {
        this.httpConnectTimeoutMs = n2;
        this.httpReadTimeoutMs = n3;
        this.httpRequestSender = null;
    }

    public DefaultEntityStatementRetriever(HTTPRequestSender hTTPRequestSender) {
        if (hTTPRequestSender == null) {
            throw new IllegalArgumentException("The HTTP request sender must not be null");
        }
        this.httpRequestSender = hTTPRequestSender;
        this.httpConnectTimeoutMs = 0;
        this.httpReadTimeoutMs = 0;
    }

    public int getHTTPConnectTimeout() {
        return this.httpConnectTimeoutMs;
    }

    public int getHTTPReadTimeout() {
        return this.httpReadTimeoutMs;
    }

    void applyTimeouts(HTTPRequest hTTPRequest) {
        hTTPRequest.setConnectTimeout(this.httpConnectTimeoutMs);
        hTTPRequest.setReadTimeout(this.httpReadTimeoutMs);
    }

    @Override
    public EntityStatement fetchEntityConfiguration(EntityID entityID) throws ResolveException {
        FederationEntityConfigurationResponse federationEntityConfigurationResponse;
        HTTPResponse hTTPResponse;
        FederationEntityConfigurationRequest federationEntityConfigurationRequest = new FederationEntityConfigurationRequest(entityID);
        HTTPRequest hTTPRequest = federationEntityConfigurationRequest.toHTTPRequest();
        this.applyTimeouts(hTTPRequest);
        this.record(hTTPRequest);
        try {
            hTTPResponse = this.httpRequestSender != null ? hTTPRequest.send(this.httpRequestSender) : hTTPRequest.send();
        }
        catch (IOException iOException) {
            throw new ResolveException("Couldn't retrieve entity configuration for " + hTTPRequest.getURL() + ": " + iOException.getMessage(), iOException);
        }
        if (StringUtils.isNotBlank(entityID.toURI().getPath()) && 404 == hTTPResponse.getStatusCode()) {
            federationEntityConfigurationRequest = new FederationEntityConfigurationRequest(entityID, WellKnownPathComposeStrategy.INFIX);
            hTTPRequest = federationEntityConfigurationRequest.toHTTPRequest();
            this.applyTimeouts(hTTPRequest);
            this.record(hTTPRequest);
            try {
                hTTPResponse = hTTPRequest.send();
            }
            catch (IOException iOException) {
                throw new ResolveException("Couldn't retrieve entity configuration for " + hTTPRequest.getURL() + ": " + iOException.getMessage(), iOException);
            }
        }
        try {
            federationEntityConfigurationResponse = FederationEntityConfigurationResponse.parse(hTTPResponse);
        }
        catch (ParseException parseException) {
            throw new ResolveException("Error parsing entity configuration response from " + hTTPRequest.getURL() + ": " + parseException.getMessage(), parseException);
        }
        if (!federationEntityConfigurationResponse.indicatesSuccess()) {
            ErrorObject errorObject = federationEntityConfigurationResponse.toErrorResponse().getErrorObject();
            throw new ResolveException("Entity configuration error response from " + hTTPRequest.getURL() + ": " + errorObject.getHTTPStatusCode() + (errorObject.getCode() != null ? " " + errorObject.getCode() : ""), errorObject);
        }
        return federationEntityConfigurationResponse.toSuccessResponse().getEntityStatement();
    }

    @Override
    public EntityStatement fetchEntityStatement(URI uRI, EntityID entityID, EntityID entityID2) throws ResolveException {
        FetchEntityStatementResponse fetchEntityStatementResponse;
        HTTPResponse hTTPResponse;
        FetchEntityStatementRequest fetchEntityStatementRequest = new FetchEntityStatementRequest(uRI, entityID, entityID2);
        HTTPRequest hTTPRequest = fetchEntityStatementRequest.toHTTPRequest();
        this.applyTimeouts(hTTPRequest);
        this.record(hTTPRequest);
        try {
            hTTPResponse = hTTPRequest.send();
        }
        catch (IOException iOException) {
            throw new ResolveException("Couldn't fetch entity statement from " + entityID + " at " + uRI + ": " + iOException.getMessage(), iOException);
        }
        try {
            fetchEntityStatementResponse = FetchEntityStatementResponse.parse(hTTPResponse);
        }
        catch (ParseException parseException) {
            throw new ResolveException("Error parsing entity statement response from " + entityID + " at " + uRI + ": " + parseException.getMessage(), parseException);
        }
        if (!fetchEntityStatementResponse.indicatesSuccess()) {
            FederationAPIError federationAPIError = fetchEntityStatementResponse.toErrorResponse().getErrorObject();
            throw new ResolveException("Entity statement error response from " + entityID + " at " + uRI + ": " + federationAPIError.getHTTPStatusCode() + (federationAPIError.getCode() != null ? " " + federationAPIError.getCode() : ""), federationAPIError);
        }
        return fetchEntityStatementResponse.toSuccessResponse().getEntityStatement();
    }

    private void record(HTTPRequest hTTPRequest) {
        this.recordedRequests.add(hTTPRequest.getURI());
    }

    public List<URI> getRecordedRequests() {
        return this.recordedRequests;
    }
}

