/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.BooleanConfiguration;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.JSONObjectConfiguration;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.NumberConfiguration;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.OperationName;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.StringConfiguration;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.StringListConfiguration;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.UntypedOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.ConfigurationType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.Utils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class ValueOperation
implements BooleanConfiguration,
JSONObjectConfiguration,
NumberConfiguration,
PolicyOperation,
StringConfiguration,
StringListConfiguration,
UntypedOperation {
    public static final OperationName NAME = new OperationName("value");
    private ConfigurationType configType;
    private boolean booleanValue;
    private Number numberValue = null;
    private String stringValue;
    private List<String> stringListValue;
    private JSONObject jsonObjectValue;

    @Override
    public OperationName getOperationName() {
        return NAME;
    }

    @Override
    public void configure(boolean bl2) {
        this.configType = ConfigurationType.BOOLEAN;
        this.booleanValue = bl2;
    }

    @Override
    public void configure(Number number) {
        this.configType = ConfigurationType.NUMBER;
        this.numberValue = number;
    }

    @Override
    public void configure(String string) {
        this.configType = ConfigurationType.STRING;
        this.stringValue = string;
    }

    @Override
    public void configure(List<String> list) {
        this.configType = ConfigurationType.STRING_LIST;
        this.stringListValue = list;
    }

    @Override
    public void configure(JSONObject jSONObject) {
        this.configType = ConfigurationType.JSON_OBJECT;
        this.jsonObjectValue = jSONObject;
    }

    @Override
    public void parseConfiguration(Object object) throws ParseException {
        if (object instanceof Boolean) {
            this.configure(JSONUtils.toBoolean(object));
        } else if (object instanceof Number) {
            this.configure(JSONUtils.toNumber(object));
        } else if (object instanceof String) {
            this.configure(JSONUtils.toString(object));
        } else if (object instanceof JSONObject) {
            this.configure(JSONUtils.to(object, JSONObject.class));
        } else {
            this.configure(JSONUtils.toStringList(object));
        }
    }

    @Override
    public Map.Entry<String, Object> toJSONObjectEntry() {
        Object object;
        if (this.configType == null) {
            throw new IllegalStateException("The policy is not initialized");
        }
        if (this.configType.equals((Object)ConfigurationType.BOOLEAN)) {
            object = this.getBooleanConfiguration();
        } else if (this.configType.equals((Object)ConfigurationType.NUMBER)) {
            object = this.getNumberConfiguration();
        } else if (this.configType.equals((Object)ConfigurationType.STRING)) {
            object = this.getStringConfiguration();
        } else if (this.configType.equals((Object)ConfigurationType.STRING_LIST)) {
            object = this.getStringListConfiguration();
        } else if (this.configType.equals((Object)ConfigurationType.JSON_OBJECT)) {
            object = this.getJSONObjectConfiguration();
        } else {
            throw new IllegalStateException("Unsupported configuration type: " + (Object)((Object)this.configType));
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(this.getOperationName().getValue(), object);
    }

    @Override
    public boolean getBooleanConfiguration() {
        return this.booleanValue;
    }

    @Override
    public Number getNumberConfiguration() {
        return this.numberValue;
    }

    @Override
    public String getStringConfiguration() {
        return this.stringValue;
    }

    @Override
    public List<String> getStringListConfiguration() {
        return this.stringListValue;
    }

    @Override
    public JSONObject getJSONObjectConfiguration() {
        return this.jsonObjectValue;
    }

    @Override
    public PolicyOperation merge(PolicyOperation policyOperation) throws PolicyViolationException {
        ValueOperation valueOperation = Utils.castForMerge(policyOperation, ValueOperation.class);
        if (this.configType == null || valueOperation.configType == null) {
            throw new PolicyViolationException("The value operation is not initialized");
        }
        if (this.configType.equals((Object)ConfigurationType.STRING_LIST) && this.getStringListConfiguration() != null && this.getStringListConfiguration().equals(valueOperation.getStringListConfiguration())) {
            ValueOperation valueOperation2 = new ValueOperation();
            valueOperation2.configure(this.getStringListConfiguration());
            return valueOperation2;
        }
        if (this.configType.equals((Object)ConfigurationType.STRING) && this.getStringConfiguration() != null && this.getStringConfiguration().equals(valueOperation.getStringConfiguration())) {
            ValueOperation valueOperation3 = new ValueOperation();
            valueOperation3.configure(this.getStringConfiguration());
            return valueOperation3;
        }
        if (this.configType.equals((Object)ConfigurationType.BOOLEAN) && this.getBooleanConfiguration() == valueOperation.getBooleanConfiguration()) {
            ValueOperation valueOperation4 = new ValueOperation();
            valueOperation4.configure(this.getBooleanConfiguration());
            return valueOperation4;
        }
        if (this.configType.equals((Object)ConfigurationType.NUMBER) && this.getNumberConfiguration() != null && this.getNumberConfiguration().equals(valueOperation.getNumberConfiguration())) {
            ValueOperation valueOperation5 = new ValueOperation();
            valueOperation5.configure(this.getNumberConfiguration());
            return valueOperation5;
        }
        if (this.configType.equals((Object)ConfigurationType.JSON_OBJECT) && this.getJSONObjectConfiguration() == valueOperation.getJSONObjectConfiguration()) {
            ValueOperation valueOperation6 = new ValueOperation();
            valueOperation6.configure(this.getJSONObjectConfiguration());
            return valueOperation6;
        }
        throw new PolicyViolationException("Value mismatch");
    }

    @Override
    public Object apply(Object object) {
        if (this.configType == null) {
            throw new IllegalStateException("The policy is not initialized");
        }
        if (this.configType.equals((Object)ConfigurationType.BOOLEAN)) {
            return this.booleanValue;
        }
        if (this.configType.equals((Object)ConfigurationType.NUMBER)) {
            return this.numberValue;
        }
        if (this.configType.equals((Object)ConfigurationType.STRING)) {
            return this.stringValue;
        }
        if (this.configType.equals((Object)ConfigurationType.JSON_OBJECT)) {
            return this.jsonObjectValue;
        }
        return this.stringListValue;
    }
}

