/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations;

import java.util.AbstractMap;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.BooleanConfiguration;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.OperationName;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.UntypedOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.Utils;

public class EssentialOperation
implements BooleanConfiguration,
PolicyOperation,
UntypedOperation {
    public static final OperationName NAME = new OperationName("essential");
    private boolean enable = false;

    @Override
    public OperationName getOperationName() {
        return NAME;
    }

    @Override
    public void configure(boolean bl2) {
        this.enable = bl2;
    }

    @Override
    public void parseConfiguration(Object object) throws ParseException {
        this.configure(JSONUtils.toBoolean(object));
    }

    @Override
    public Map.Entry<String, Object> toJSONObjectEntry() {
        return new AbstractMap.SimpleImmutableEntry<String, Object>(this.getOperationName().getValue(), this.getBooleanConfiguration());
    }

    @Override
    public boolean getBooleanConfiguration() {
        return this.enable;
    }

    @Override
    public PolicyOperation merge(PolicyOperation policyOperation) throws PolicyViolationException {
        EssentialOperation essentialOperation = Utils.castForMerge(policyOperation, EssentialOperation.class);
        if (this.getBooleanConfiguration() == essentialOperation.getBooleanConfiguration()) {
            EssentialOperation essentialOperation2 = new EssentialOperation();
            essentialOperation2.configure(this.getBooleanConfiguration());
            return essentialOperation2;
        }
        throw new PolicyViolationException("Essential value mismatch");
    }

    @Override
    public Object apply(Object object) throws PolicyViolationException {
        if (this.enable && object == null) {
            throw new PolicyViolationException("Essential parameter not present");
        }
        return object;
    }
}

