/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.CommonFederationClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints.TrustChainConstraints;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkEntry;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkIssuerMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class EntityStatementClaimsSet
extends CommonFederationClaimsSet {
    public static final String JWKS_CLAIM_NAME = "jwks";
    public static final String AUTHORITY_HINTS_CLAIM_NAME = "authority_hints";
    public static final String METADATA_POLICY_CLAIM_NAME = "metadata_policy";
    public static final String TRUST_ANCHOR_ID_CLAIM_NAME = "trust_anchor_id";
    public static final String CONSTRAINTS_CLAIM_NAME = "constraints";
    public static final String TRUST_MARKS_ISSUERS_CLAIM_NAME = "trust_marks_issuers";
    public static final String CRITICAL_CLAIM_NAME = "crit";
    public static final String POLICY_LANGUAGE_CRITICAL_CLAIM_NAME = "policy_language_crit";
    private static final Set<String> STD_CLAIM_NAMES;

    public static Set<String> getStandardClaimNames() {
        return STD_CLAIM_NAMES;
    }

    public EntityStatementClaimsSet(Issuer issuer, Subject subject, Date date, Date date2, JWKSet jWKSet) {
        this(new EntityID(issuer.getValue()), new EntityID(subject.getValue()), date, date2, jWKSet);
    }

    public EntityStatementClaimsSet(EntityID entityID, EntityID entityID2, Date date, Date date2, JWKSet jWKSet) {
        this.setClaim("iss", entityID.getValue());
        this.setClaim("sub", entityID2.getValue());
        if (date == null) {
            throw new IllegalArgumentException("The iat (issued-at) claim must not be null");
        }
        this.setDateClaim("iat", date);
        if (date2 == null) {
            throw new IllegalArgumentException("The exp (expiration) claim must not be null");
        }
        this.setDateClaim("exp", date2);
        if (jWKSet != null) {
            this.setClaim(JWKS_CLAIM_NAME, new JSONObject(jWKSet.toJSONObject(true)));
        }
    }

    public EntityStatementClaimsSet(JWTClaimsSet jWTClaimsSet) throws ParseException {
        super(JSONObjectUtils.toJSONObject(jWTClaimsSet));
        this.validateRequiredClaimsPresence();
    }

    @Override
    public void validateRequiredClaimsPresence() throws ParseException {
        super.validateRequiredClaimsPresence();
        if (this.isSelfStatement() && this.getJWKSet() == null) {
            throw new ParseException("Missing jwks (JWK set) claim");
        }
        if (this.isSelfStatement() && !this.hasMetadata()) {
            throw new ParseException("Missing required metadata claim for self-statement");
        }
        List<String> list = this.getCriticalExtensionClaims();
        if (list != null) {
            for (String string : list) {
                if (this.getClaim(string) != null) continue;
                throw new ParseException("Missing critical " + string + " claim");
            }
        }
    }

    public boolean isSelfStatement() {
        Issuer issuer = this.getIssuer();
        Subject subject = this.getSubject();
        return issuer != null && subject != null && issuer.getValue().equals(subject.getValue());
    }

    public JWKSet getJWKSet() {
        JSONObject jSONObject = this.getJSONObjectClaim(JWKS_CLAIM_NAME);
        if (jSONObject == null) {
            return null;
        }
        try {
            return JWKSet.parse(jSONObject);
        }
        catch (java.text.ParseException parseException) {
            return null;
        }
    }

    public List<EntityID> getAuthorityHints() {
        List<String> list = this.getStringListClaim(AUTHORITY_HINTS_CLAIM_NAME);
        if (list == null) {
            return null;
        }
        LinkedList<EntityID> linkedList = new LinkedList<EntityID>();
        for (String string : list) {
            linkedList.add(new EntityID(string));
        }
        return linkedList;
    }

    public void setAuthorityHints(List<EntityID> list) {
        if (list != null) {
            this.setClaim(AUTHORITY_HINTS_CLAIM_NAME, Identifier.toStringList(list));
        } else {
            this.setClaim(AUTHORITY_HINTS_CLAIM_NAME, null);
        }
    }

    public boolean hasMetadata() {
        JSONObject jSONObject = this.getJSONObjectClaim("metadata");
        if (MapUtils.isEmpty(jSONObject)) {
            return false;
        }
        if (jSONObject.get(EntityType.OPENID_RELYING_PARTY.getValue()) != null) {
            return true;
        }
        if (jSONObject.get(EntityType.OPENID_PROVIDER.getValue()) != null) {
            return true;
        }
        if (jSONObject.get(EntityType.OAUTH_AUTHORIZATION_SERVER.getValue()) != null) {
            return true;
        }
        if (jSONObject.get(EntityType.OAUTH_CLIENT.getValue()) != null) {
            return true;
        }
        if (jSONObject.get(EntityType.OAUTH_RESOURCE.getValue()) != null) {
            return true;
        }
        if (jSONObject.get(EntityType.FEDERATION_ENTITY.getValue()) != null) {
            return true;
        }
        return jSONObject.get(EntityType.TRUST_MARK_ISSUER.getValue()) != null;
    }

    public OIDCClientInformation getRPInformation() {
        JSONObject jSONObject = this.getMetadata(EntityType.OPENID_RELYING_PARTY);
        if (jSONObject == null) {
            return null;
        }
        try {
            return OIDCClientInformation.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setRPInformation(OIDCClientInformation oIDCClientInformation) {
        JSONObject jSONObject = oIDCClientInformation != null ? oIDCClientInformation.toJSONObject() : null;
        this.setMetadata(EntityType.OPENID_RELYING_PARTY, jSONObject);
    }

    @Deprecated
    public void setTrustMarkIssuerMetadata(TrustMarkIssuerMetadata trustMarkIssuerMetadata) {
        JSONObject jSONObject = trustMarkIssuerMetadata != null ? trustMarkIssuerMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.TRUST_MARK_ISSUER, jSONObject);
    }

    public JSONObject getMetadataPolicyJSONObject() {
        return this.getJSONObjectClaim(METADATA_POLICY_CLAIM_NAME);
    }

    public void setMetadataPolicyJSONObject(JSONObject jSONObject) {
        this.setClaim(METADATA_POLICY_CLAIM_NAME, jSONObject);
    }

    public MetadataPolicy getMetadataPolicy(EntityType entityType) throws PolicyViolationException {
        JSONObject jSONObject = this.getMetadataPolicyJSONObject();
        if (jSONObject == null) {
            return null;
        }
        try {
            JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, entityType.getValue(), null);
            if (jSONObject2 == null) {
                return null;
            }
            return MetadataPolicy.parse(jSONObject2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setMetadataPolicy(EntityType entityType, MetadataPolicy metadataPolicy) {
        JSONObject jSONObject = this.getMetadataPolicyJSONObject();
        if (jSONObject == null) {
            if (metadataPolicy == null) {
                return;
            }
            jSONObject = new JSONObject();
        }
        if (metadataPolicy != null) {
            jSONObject.put(entityType.getValue(), metadataPolicy.toJSONObject());
        } else {
            jSONObject.remove(entityType.getValue());
        }
        if (jSONObject.isEmpty()) {
            jSONObject = null;
        }
        this.setMetadataPolicyJSONObject(jSONObject);
    }

    public EntityID getTrustAnchorID() {
        String string = this.getStringClaim(TRUST_ANCHOR_ID_CLAIM_NAME);
        try {
            return EntityID.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setTrustAnchorID(EntityID entityID) {
        if (entityID != null) {
            this.setClaim(TRUST_ANCHOR_ID_CLAIM_NAME, entityID.getValue());
        } else {
            this.setClaim(TRUST_ANCHOR_ID_CLAIM_NAME, null);
        }
    }

    public TrustChainConstraints getConstraints() {
        JSONObject jSONObject = this.getJSONObjectClaim(CONSTRAINTS_CLAIM_NAME);
        if (jSONObject == null) {
            return null;
        }
        try {
            return TrustChainConstraints.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setConstraints(TrustChainConstraints trustChainConstraints) {
        if (trustChainConstraints != null) {
            this.setClaim(CONSTRAINTS_CLAIM_NAME, trustChainConstraints.toJSONObject());
        } else {
            this.setClaim(CONSTRAINTS_CLAIM_NAME, null);
        }
    }

    @Override
    public void setTrustMarks(List<TrustMarkEntry> list) {
        if (list != null) {
            JSONArray jSONArray = new JSONArray();
            for (TrustMarkEntry trustMarkEntry : list) {
                jSONArray.add(trustMarkEntry.toJSONObject());
            }
            this.setClaim("trust_marks", jSONArray);
        } else {
            this.setClaim("trust_marks", null);
        }
    }

    public Map<Identifier, List<Issuer>> getTrustMarksIssuers() {
        JSONObject jSONObject = this.getJSONObjectClaim(TRUST_MARKS_ISSUERS_CLAIM_NAME);
        if (jSONObject == null) {
            return null;
        }
        HashMap<Identifier, List<Issuer>> hashMap = new HashMap<Identifier, List<Issuer>>();
        for (String string : jSONObject.keySet()) {
            try {
                LinkedList<Issuer> linkedList = new LinkedList<Issuer>();
                for (String string2 : JSONObjectUtils.getStringList(jSONObject, string)) {
                    linkedList.add(new Issuer(string2));
                }
                hashMap.put(new Identifier(string), linkedList);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return hashMap;
    }

    public void setTrustMarksIssuers(Map<Identifier, List<Issuer>> map) {
        if (map != null) {
            JSONObject jSONObject = new JSONObject();
            for (Map.Entry<Identifier, List<Issuer>> entry : map.entrySet()) {
                jSONObject.put(entry.getKey().getValue(), Issuer.toStringList((Collection<? extends Identifier>)entry.getValue()));
                this.setClaim(TRUST_MARKS_ISSUERS_CLAIM_NAME, jSONObject);
            }
        } else {
            this.setClaim(TRUST_MARKS_ISSUERS_CLAIM_NAME, null);
        }
    }

    public List<String> getCriticalExtensionClaims() {
        return this.getStringListClaim(CRITICAL_CLAIM_NAME);
    }

    public void setCriticalExtensionClaims(List<String> list) {
        if (list != null && list.isEmpty()) {
            throw new IllegalArgumentException("The critical extension claim names must not be empty");
        }
        this.setClaim(CRITICAL_CLAIM_NAME, list);
    }

    public List<String> getCriticalPolicyExtensions() {
        return this.getStringListClaim(POLICY_LANGUAGE_CRITICAL_CLAIM_NAME);
    }

    public void setCriticalPolicyExtensions(List<String> list) {
        if (list != null && list.isEmpty()) {
            throw new IllegalArgumentException("The critical policy extension names must not be empty");
        }
        this.setClaim(POLICY_LANGUAGE_CRITICAL_CLAIM_NAME, list);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("iss");
        hashSet.add("sub");
        hashSet.add("iat");
        hashSet.add("exp");
        hashSet.add(JWKS_CLAIM_NAME);
        hashSet.add("aud");
        hashSet.add(AUTHORITY_HINTS_CLAIM_NAME);
        hashSet.add("metadata");
        hashSet.add(METADATA_POLICY_CLAIM_NAME);
        hashSet.add(CONSTRAINTS_CLAIM_NAME);
        hashSet.add(CRITICAL_CLAIM_NAME);
        hashSet.add(POLICY_LANGUAGE_CRITICAL_CLAIM_NAME);
        hashSet.add("trust_marks");
        hashSet.add(TRUST_MARKS_ISSUERS_CLAIM_NAME);
        hashSet.add(TRUST_ANCHOR_ID_CLAIM_NAME);
        STD_CLAIM_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

