/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.ResolveResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.ResolveStatement;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class ResolveSuccessResponse
extends ResolveResponse {
    private final ResolveStatement resolveStatement;

    public ResolveSuccessResponse(ResolveStatement resolveStatement) {
        if (resolveStatement == null) {
            throw new IllegalArgumentException("The resolve statement must not be null");
        }
        this.resolveStatement = resolveStatement;
    }

    public ResolveStatement getResolveStatement() {
        return this.resolveStatement;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = new HTTPResponse(200);
        hTTPResponse.setEntityContentType(ResolveStatement.CONTENT_TYPE);
        hTTPResponse.setContent(this.getResolveStatement().getSignedStatement().serialize());
        return hTTPResponse;
    }

    public static ResolveSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCode(200);
        hTTPResponse.ensureEntityContentType(ResolveStatement.CONTENT_TYPE);
        return new ResolveSuccessResponse(ResolveStatement.parse(hTTPResponse.getContent()));
    }
}

