/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class ResolveRequest
extends FederationAPIRequest {
    private final Subject subject;
    private final EntityID anchor;
    private final EntityType entityType;

    public ResolveRequest(URI uRI, Subject subject, EntityID entityID, EntityType entityType) {
        super(uRI);
        if (subject == null) {
            throw new IllegalArgumentException("The subject must not be null");
        }
        this.subject = subject;
        if (entityID == null) {
            throw new IllegalArgumentException("The anchor must not be null");
        }
        this.anchor = entityID;
        this.entityType = entityType;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public EntityID getSubjectEntityID() {
        return new EntityID(this.subject);
    }

    public EntityID getTrustAnchor() {
        return this.anchor;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("sub", Collections.singletonList(this.getSubject().getValue()));
        linkedHashMap.put("anchor", Collections.singletonList(this.getTrustAnchor().getValue()));
        if (this.getEntityType() != null) {
            linkedHashMap.put("type", Collections.singletonList(this.getEntityType().getValue()));
        }
        return linkedHashMap;
    }

    public static ResolveRequest parse(Map<String, List<String>> map) throws ParseException {
        String string = MultivaluedMapUtils.getFirstValue(map, "sub");
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Missing sub");
        }
        Subject subject = new Subject(string);
        string = MultivaluedMapUtils.getFirstValue(map, "anchor");
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Missing anchor");
        }
        EntityID entityID = new EntityID(string);
        EntityType entityType = null;
        string = MultivaluedMapUtils.getFirstValue(map, "type");
        if (StringUtils.isNotBlank(string)) {
            entityType = new EntityType(string);
        }
        return new ResolveRequest(null, subject, entityID, entityType);
    }

    public static ResolveRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.GET);
        ResolveRequest resolveRequest = ResolveRequest.parse(hTTPRequest.getQueryStringParameters());
        return new ResolveRequest(URIUtils.getBaseURI(hTTPRequest.getURI()), resolveRequest.getSubject(), resolveRequest.getTrustAnchor(), resolveRequest.getEntityType());
    }
}

