/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.CommonFederationClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.TrustChain;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class ResolveClaimsSet
extends CommonFederationClaimsSet {
    public static final String TRUST_CHAIN_CLAIM_NAME = "trust_chain";
    private static final Set<String> STD_CLAIM_NAMES;

    public static Set<String> getStandardClaimNames() {
        return STD_CLAIM_NAMES;
    }

    public ResolveClaimsSet(Issuer issuer, Subject subject, Date date, Date date2, JSONObject jSONObject) {
        this(new EntityID(issuer.getValue()), new EntityID(subject.getValue()), date, date2, jSONObject);
    }

    public ResolveClaimsSet(EntityID entityID, EntityID entityID2, Date date, Date date2, JSONObject jSONObject) {
        this.setClaim("iss", entityID.getValue());
        this.setClaim("sub", entityID2.getValue());
        if (date == null) {
            throw new IllegalArgumentException("The iat (issued-at) claim must not be null");
        }
        this.setDateClaim("iat", date);
        if (date2 == null) {
            throw new IllegalArgumentException("The exp (expiration) claim must not be null");
        }
        this.setDateClaim("exp", date2);
        if (jSONObject == null || jSONObject.isEmpty()) {
            throw new IllegalArgumentException("The metadata claim must not be null");
        }
        this.setClaim("metadata", jSONObject);
    }

    public ResolveClaimsSet(JWTClaimsSet jWTClaimsSet) throws ParseException {
        super(JSONObjectUtils.toJSONObject(jWTClaimsSet));
        this.validateRequiredClaimsPresence();
    }

    @Override
    public void validateRequiredClaimsPresence() throws ParseException {
        super.validateRequiredClaimsPresence();
        if (MapUtils.isEmpty(this.getJSONObjectClaim("metadata"))) {
            throw new ParseException("Missing metadata claim");
        }
    }

    public TrustChain getTrustChain() {
        List<String> list = this.getStringListClaim(TRUST_CHAIN_CLAIM_NAME);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        try {
            return TrustChain.parseSerialized(list);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setTrustChain(TrustChain trustChain) {
        if (trustChain != null) {
            this.setClaim(TRUST_CHAIN_CLAIM_NAME, trustChain.toSerializedJWTs());
        } else {
            this.setClaim(TRUST_CHAIN_CLAIM_NAME, null);
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("iss");
        hashSet.add("sub");
        hashSet.add("iat");
        hashSet.add("exp");
        hashSet.add("metadata");
        hashSet.add("trust_marks");
        hashSet.add(TRUST_CHAIN_CLAIM_NAME);
        STD_CLAIM_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

