/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class FetchEntityStatementRequest
extends FederationAPIRequest {
    private final Issuer issuer;
    private final Subject subject;

    public FetchEntityStatementRequest(URI uRI, Issuer issuer, Subject subject) {
        super(uRI);
        this.issuer = issuer;
        this.subject = subject;
    }

    public FetchEntityStatementRequest(URI uRI, EntityID entityID, EntityID entityID2) {
        this(uRI, entityID != null ? new Issuer(entityID.getValue()) : null, entityID2 != null ? new Subject(entityID2.getValue()) : null);
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public EntityID getIssuerEntityID() {
        return this.getIssuer() != null ? new EntityID(this.getIssuer().getValue()) : null;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public EntityID getSubjectEntityID() {
        return this.getSubject() != null ? new EntityID(this.getSubject().getValue()) : null;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (this.getIssuer() != null) {
            hashMap.put("iss", Collections.singletonList(this.getIssuer().getValue()));
        }
        if (this.getSubject() != null) {
            hashMap.put("sub", Collections.singletonList(this.getSubject().getValue()));
        }
        return hashMap;
    }

    public static FetchEntityStatementRequest parse(Map<String, List<String>> map) throws ParseException {
        String string = MultivaluedMapUtils.getFirstValue(map, "iss");
        Issuer issuer = null;
        if (string != null) {
            issuer = new Issuer(string);
        }
        string = MultivaluedMapUtils.getFirstValue(map, "sub");
        Subject subject = null;
        if (string != null) {
            subject = new Subject(string);
        }
        return new FetchEntityStatementRequest(null, issuer, subject);
    }

    public static FetchEntityStatementRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.GET);
        FetchEntityStatementRequest fetchEntityStatementRequest = FetchEntityStatementRequest.parse(hTTPRequest.getQueryStringParameters());
        return new FetchEntityStatementRequest(URIUtils.getBaseURI(hTTPRequest.getURI()), fetchEntityStatementRequest.getIssuer(), fetchEntityStatementRequest.getSubject());
    }
}

