/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;

public abstract class HashClaim
extends Identifier {
    private static final long serialVersionUID = -3163141692378087888L;

    protected HashClaim(String string) {
        super(string);
    }

    @Deprecated
    public static MessageDigest getMessageDigestInstance(JWSAlgorithm jWSAlgorithm) {
        return HashClaim.getMessageDigestInstance(jWSAlgorithm, null);
    }

    public static MessageDigest getMessageDigestInstance(JWSAlgorithm jWSAlgorithm, Curve curve) {
        String string;
        if (jWSAlgorithm.equals(JWSAlgorithm.HS256) || jWSAlgorithm.equals(JWSAlgorithm.RS256) || jWSAlgorithm.equals(JWSAlgorithm.ES256) || jWSAlgorithm.equals(JWSAlgorithm.ES256K) || jWSAlgorithm.equals(JWSAlgorithm.PS256)) {
            string = "SHA-256";
        } else if (jWSAlgorithm.equals(JWSAlgorithm.HS384) || jWSAlgorithm.equals(JWSAlgorithm.RS384) || jWSAlgorithm.equals(JWSAlgorithm.ES384) || jWSAlgorithm.equals(JWSAlgorithm.PS384)) {
            string = "SHA-384";
        } else if (jWSAlgorithm.equals(JWSAlgorithm.HS512) || jWSAlgorithm.equals(JWSAlgorithm.RS512) || jWSAlgorithm.equals(JWSAlgorithm.ES512) || jWSAlgorithm.equals(JWSAlgorithm.PS512) || jWSAlgorithm.equals(JWSAlgorithm.EdDSA) && Curve.Ed25519.equals(curve)) {
            string = "SHA-512";
        } else {
            return null;
        }
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    @Deprecated
    public static String computeValue(Identifier identifier, JWSAlgorithm jWSAlgorithm) {
        return HashClaim.computeValue(identifier, jWSAlgorithm, null);
    }

    public static String computeValue(Identifier identifier, JWSAlgorithm jWSAlgorithm, Curve curve) {
        MessageDigest messageDigest = HashClaim.getMessageDigestInstance(jWSAlgorithm, curve);
        if (messageDigest == null) {
            return null;
        }
        messageDigest.update(identifier.getValue().getBytes(StandardCharsets.US_ASCII));
        byte[] byArray = messageDigest.digest();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length / 2);
        return Base64URL.encode(byArray2).toString();
    }
}

