/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request;

import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.IdentityTrustFramework;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.request.VerificationSpec;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class MinimalVerificationSpec
implements VerificationSpec {
    protected final JSONObject jsonObject;

    protected MinimalVerificationSpec(JSONObject jSONObject) {
        Objects.requireNonNull(jSONObject);
        this.jsonObject = jSONObject;
    }

    public MinimalVerificationSpec() {
        this(new JSONObject());
        this.jsonObject.put("trust_framework", null);
    }

    public MinimalVerificationSpec(IdentityTrustFramework identityTrustFramework) {
        this();
        if (identityTrustFramework != null) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("value", identityTrustFramework.getValue());
            this.jsonObject.put("trust_framework", jSONObject);
        }
    }

    public MinimalVerificationSpec(List<IdentityTrustFramework> list) {
        this();
        if (CollectionUtils.isNotEmpty(list)) {
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            for (IdentityTrustFramework identityTrustFramework : list) {
                if (identityTrustFramework == null) continue;
                jSONArray.add(identityTrustFramework.getValue());
            }
            jSONObject.put("values", jSONArray);
            this.jsonObject.put("trust_framework", jSONObject);
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.putAll(this.jsonObject);
        return jSONObject;
    }

    public static MinimalVerificationSpec parse(JSONObject jSONObject) throws ParseException {
        if (!jSONObject.containsKey("trust_framework")) {
            throw new ParseException("Missing required trust_framework key");
        }
        if (jSONObject.get("trust_framework") != null) {
            JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, "trust_framework");
            try {
                MinimalVerificationSpec.validateTrustFrameworkSpec(jSONObject2);
            }
            catch (ParseException parseException) {
                throw new ParseException("Invalid trust_framework spec: " + parseException.getMessage(), parseException);
            }
        }
        return new MinimalVerificationSpec(jSONObject);
    }

    private static void validateTrustFrameworkSpec(JSONObject jSONObject) throws ParseException {
        String string = null;
        if (jSONObject.containsKey("value")) {
            string = JSONObjectUtils.getString(jSONObject, "value");
        }
        List<String> list = null;
        if (jSONObject.containsKey("values") && (list = JSONObjectUtils.getStringList(jSONObject, "values")).isEmpty()) {
            throw new ParseException("The values JSON array must not be empty");
        }
        if (string != null && list != null) {
            throw new ParseException("Value and values must not be set together");
        }
    }
}

