/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.Policy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.Procedure;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.Status;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.CommonMethodAttributes;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.VerificationMethodType;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class VerificationMethod
extends CommonMethodAttributes {
    private final VerificationMethodType type;

    public VerificationMethod(VerificationMethodType verificationMethodType, Policy policy, Procedure procedure, Status status) {
        super(policy, procedure, status);
        Objects.requireNonNull(verificationMethodType);
        this.type = verificationMethodType;
    }

    public VerificationMethodType getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VerificationMethod)) {
            return false;
        }
        VerificationMethod verificationMethod = (VerificationMethod)object;
        return this.getType().equals(verificationMethod.getType()) && Objects.equals(this.getPolicy(), verificationMethod.getPolicy()) && Objects.equals(this.getProcedure(), verificationMethod.getProcedure()) && Objects.equals(this.getStatus(), verificationMethod.getStatus());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getPolicy(), this.getProcedure(), this.getStatus());
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("type", this.getType().getValue());
        return jSONObject;
    }

    public static VerificationMethod parse(JSONObject jSONObject) throws ParseException {
        try {
            VerificationMethodType verificationMethodType = new VerificationMethodType(JSONObjectUtils.getString(jSONObject, "type"));
            Policy policy = null;
            if (jSONObject.get("policy") != null) {
                policy = new Policy(JSONObjectUtils.getString(jSONObject, "policy"));
            }
            Procedure procedure = null;
            if (jSONObject.get("procedure") != null) {
                procedure = new Procedure(JSONObjectUtils.getString(jSONObject, "procedure"));
            }
            Status status = null;
            if (jSONObject.get("status") != null) {
                status = new Status(JSONObjectUtils.getString(jSONObject, "status"));
            }
            return new VerificationMethod(verificationMethodType, policy, procedure, status);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }
}

