/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date.DateWithTimeZoneOffset;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidenceType;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Deprecated
public class QESEvidence
extends IdentityEvidence {
    private final Issuer issuer;
    private final String serialNumber;
    private final DateWithTimeZoneOffset createdAt;

    public QESEvidence(Issuer issuer, String string, DateWithTimeZoneOffset dateWithTimeZoneOffset) {
        super(IdentityEvidenceType.QES, null);
        this.issuer = issuer;
        this.serialNumber = string;
        this.createdAt = dateWithTimeZoneOffset;
    }

    public Issuer getQESIssuer() {
        return this.issuer;
    }

    public String getQESSerialNumberString() {
        return this.serialNumber;
    }

    public DateWithTimeZoneOffset getQESCreationTime() {
        return this.createdAt;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        if (this.getQESIssuer() != null) {
            jSONObject.put("issuer", this.getQESIssuer().getValue());
        }
        if (this.getQESSerialNumberString() != null) {
            jSONObject.put("serial_number", this.getQESSerialNumberString());
        }
        if (this.getQESCreationTime() != null) {
            jSONObject.put("created_at", this.getQESCreationTime().toISO8601String());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof QESEvidence)) {
            return false;
        }
        QESEvidence qESEvidence = (QESEvidence)object;
        return Objects.equals(this.getQESIssuer(), qESEvidence.getQESIssuer()) && Objects.equals(this.getQESSerialNumberString(), qESEvidence.getQESSerialNumberString()) && Objects.equals(this.getQESCreationTime(), qESEvidence.getQESCreationTime());
    }

    public int hashCode() {
        return Objects.hash(this.getQESIssuer(), this.getQESSerialNumberString(), this.getQESCreationTime());
    }

    public static QESEvidence parse(JSONObject jSONObject) throws ParseException {
        QESEvidence.ensureType(IdentityEvidenceType.QES, jSONObject);
        Issuer issuer = null;
        if (jSONObject.get("issuer") != null) {
            issuer = new Issuer(JSONObjectUtils.getString(jSONObject, "issuer"));
        }
        String string = JSONObjectUtils.getString(jSONObject, "serial_number", null);
        DateWithTimeZoneOffset dateWithTimeZoneOffset = null;
        if (jSONObject.get("created_at") != null) {
            dateWithTimeZoneOffset = DateWithTimeZoneOffset.parseISO8601String(JSONObjectUtils.getString(jSONObject, "created_at"));
        }
        return new QESEvidence(issuer, string, dateWithTimeZoneOffset);
    }
}

