/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date.DateWithTimeZoneOffset;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.DocumentDetails;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidenceType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityVerificationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ValidationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.VerificationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Attachment;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class DocumentEvidence
extends IdentityEvidence {
    private final ValidationMethod validationMethod;
    private final VerificationMethod verificationMethod;
    @Deprecated
    private final IdentityVerificationMethod method;
    private final IdentityVerifier verifier;
    private final DateWithTimeZoneOffset time;
    private final DocumentDetails documentDetails;

    public DocumentEvidence(ValidationMethod validationMethod, VerificationMethod verificationMethod, IdentityVerificationMethod identityVerificationMethod, IdentityVerifier identityVerifier, DateWithTimeZoneOffset dateWithTimeZoneOffset, DocumentDetails documentDetails, List<Attachment> list) {
        super(IdentityEvidenceType.DOCUMENT, list);
        this.validationMethod = validationMethod;
        this.verificationMethod = verificationMethod;
        this.method = identityVerificationMethod;
        this.time = dateWithTimeZoneOffset;
        this.verifier = identityVerifier;
        this.documentDetails = documentDetails;
    }

    public ValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public VerificationMethod getVerificationMethod() {
        return this.verificationMethod;
    }

    @Deprecated
    public IdentityVerificationMethod getMethod() {
        return this.method;
    }

    public IdentityVerifier getVerifier() {
        return this.verifier;
    }

    public DateWithTimeZoneOffset getVerificationTime() {
        return this.time;
    }

    public DocumentDetails getDocumentDetails() {
        return this.documentDetails;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        if (this.getValidationMethod() != null) {
            jSONObject.put("validation_method", this.getValidationMethod().toJSONObject());
        }
        if (this.getVerificationMethod() != null) {
            jSONObject.put("verification_method", this.getVerificationMethod().toJSONObject());
        }
        if (this.getMethod() != null) {
            jSONObject.put("method", this.getMethod().getValue());
        }
        if (this.getVerifier() != null) {
            jSONObject.put("verifier", this.getVerifier().toJSONObject());
        }
        if (this.getVerificationTime() != null) {
            jSONObject.put("time", this.getVerificationTime().toISO8601String());
        }
        if (this.getDocumentDetails() != null) {
            jSONObject.put("document_details", this.getDocumentDetails().toJSONObject());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DocumentEvidence)) {
            return false;
        }
        DocumentEvidence documentEvidence = (DocumentEvidence)object;
        return Objects.equals(this.getValidationMethod(), documentEvidence.getValidationMethod()) && Objects.equals(this.getVerificationMethod(), documentEvidence.getVerificationMethod()) && Objects.equals(this.getMethod(), documentEvidence.getMethod()) && Objects.equals(this.getVerifier(), documentEvidence.getVerifier()) && Objects.equals(this.getVerificationTime(), documentEvidence.getVerificationTime()) && Objects.equals(this.getDocumentDetails(), documentEvidence.getDocumentDetails());
    }

    public int hashCode() {
        return Objects.hash(this.getValidationMethod(), this.getVerificationMethod(), this.getMethod(), this.getVerifier(), this.getVerificationTime(), this.getDocumentDetails());
    }

    public static DocumentEvidence parse(JSONObject jSONObject) throws ParseException {
        DocumentEvidence.ensureType(IdentityEvidenceType.DOCUMENT, jSONObject);
        ValidationMethod validationMethod = null;
        if (jSONObject.get("validation_method") != null) {
            validationMethod = ValidationMethod.parse(JSONObjectUtils.getJSONObject(jSONObject, "validation_method"));
        }
        VerificationMethod verificationMethod = null;
        if (jSONObject.get("verification_method") != null) {
            verificationMethod = VerificationMethod.parse(JSONObjectUtils.getJSONObject(jSONObject, "verification_method"));
        }
        IdentityVerificationMethod identityVerificationMethod = null;
        if (jSONObject.get("method") != null) {
            identityVerificationMethod = new IdentityVerificationMethod(JSONObjectUtils.getString(jSONObject, "method"));
        }
        IdentityVerifier identityVerifier = null;
        if (jSONObject.get("verifier") != null) {
            identityVerifier = IdentityVerifier.parse(JSONObjectUtils.getJSONObject(jSONObject, "verifier"));
        }
        DateWithTimeZoneOffset dateWithTimeZoneOffset = null;
        if (jSONObject.get("time") != null) {
            dateWithTimeZoneOffset = DateWithTimeZoneOffset.parseISO8601String(JSONObjectUtils.getString(jSONObject, "time"));
        }
        DocumentDetails documentDetails = null;
        if (jSONObject.get("document_details") != null) {
            documentDetails = DocumentDetails.parse(JSONObjectUtils.getJSONObject(jSONObject, "document_details"));
        }
        List<Attachment> list = null;
        if (jSONObject.get("attachments") != null) {
            list = Attachment.parseList(JSONObjectUtils.getJSONArray(jSONObject, "attachments"));
        }
        return new DocumentEvidence(validationMethod, verificationMethod, identityVerificationMethod, identityVerifier, dateWithTimeZoneOffset, documentDetails, list);
    }
}

