/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date.SimpleDate;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.DocumentIssuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.DocumentNumber;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.DocumentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.PersonalNumber;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.SerialNumber;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class DocumentDetails {
    private final DocumentType type;
    private final DocumentNumber documentNumber;
    private final PersonalNumber personalNumber;
    private final SerialNumber serialNumber;
    private final SimpleDate dateOfIssuance;
    private final SimpleDate dateOfExpiry;
    private final DocumentIssuer issuer;

    public DocumentDetails(DocumentType documentType, DocumentNumber documentNumber, PersonalNumber personalNumber, SerialNumber serialNumber, SimpleDate simpleDate, SimpleDate simpleDate2, DocumentIssuer documentIssuer) {
        Objects.requireNonNull(documentType);
        this.type = documentType;
        this.documentNumber = documentNumber;
        this.personalNumber = personalNumber;
        this.serialNumber = serialNumber;
        this.dateOfIssuance = simpleDate;
        this.dateOfExpiry = simpleDate2;
        this.issuer = documentIssuer;
    }

    public DocumentType getType() {
        return this.type;
    }

    public DocumentNumber getDocumentNumber() {
        return this.documentNumber;
    }

    public PersonalNumber getPersonalNumber() {
        return this.personalNumber;
    }

    public SerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    public SimpleDate getDateOfIssuance() {
        return this.dateOfIssuance;
    }

    public SimpleDate getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public DocumentIssuer getIssuer() {
        return this.issuer;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("type", this.getType().getValue());
        if (this.getDocumentNumber() != null) {
            jSONObject2.put("document_number", this.getDocumentNumber().getValue());
        }
        if (this.getPersonalNumber() != null) {
            jSONObject2.put("personal_number", this.getPersonalNumber().getValue());
        }
        if (this.getSerialNumber() != null) {
            jSONObject2.put("serial_number", this.getSerialNumber().getValue());
        }
        if (this.getDateOfIssuance() != null) {
            jSONObject2.put("date_of_issuance", this.getDateOfIssuance().toISO8601String());
        }
        if (this.getDateOfExpiry() != null) {
            jSONObject2.put("date_of_expiry", this.getDateOfExpiry().toISO8601String());
        }
        if (this.getIssuer() != null && !(jSONObject = this.getIssuer().toJSONObject()).isEmpty()) {
            jSONObject2.put("issuer", jSONObject);
        }
        return jSONObject2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DocumentDetails)) {
            return false;
        }
        DocumentDetails documentDetails = (DocumentDetails)object;
        return this.getType().equals(documentDetails.getType()) && Objects.equals(this.getDocumentNumber(), documentDetails.getDocumentNumber()) && Objects.equals(this.getPersonalNumber(), documentDetails.getPersonalNumber()) && Objects.equals(this.getSerialNumber(), documentDetails.getSerialNumber()) && Objects.equals(this.getDateOfIssuance(), documentDetails.getDateOfIssuance()) && Objects.equals(this.getDateOfExpiry(), documentDetails.getDateOfExpiry()) && Objects.equals(this.getIssuer(), documentDetails.getIssuer());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getDocumentNumber(), this.getPersonalNumber(), this.getSerialNumber(), this.getDateOfIssuance(), this.getDateOfExpiry(), this.getIssuer());
    }

    public static DocumentDetails parse(JSONObject jSONObject) throws ParseException {
        try {
            DocumentType documentType = new DocumentType(JSONObjectUtils.getString(jSONObject, "type"));
            DocumentNumber documentNumber = null;
            if (jSONObject.get("document_number") != null) {
                documentNumber = new DocumentNumber(JSONObjectUtils.getString(jSONObject, "document_number"));
            }
            PersonalNumber personalNumber = null;
            if (jSONObject.get("personal_number") != null) {
                personalNumber = new PersonalNumber(JSONObjectUtils.getString(jSONObject, "personal_number"));
            }
            SerialNumber serialNumber = null;
            if (jSONObject.get("serial_number") != null) {
                serialNumber = new SerialNumber(JSONObjectUtils.getString(jSONObject, "serial_number"));
            }
            SimpleDate simpleDate = null;
            if (jSONObject.get("date_of_issuance") != null) {
                simpleDate = SimpleDate.parseISO8601String(JSONObjectUtils.getString(jSONObject, "date_of_issuance"));
            }
            SimpleDate simpleDate2 = null;
            if (jSONObject.get("date_of_expiry") != null) {
                simpleDate2 = SimpleDate.parseISO8601String(JSONObjectUtils.getString(jSONObject, "date_of_expiry"));
            }
            DocumentIssuer documentIssuer = null;
            if (jSONObject.get("issuer") != null) {
                documentIssuer = DocumentIssuer.parse(JSONObjectUtils.getJSONObject(jSONObject, "issuer"));
            }
            return new DocumentDetails(documentType, documentNumber, personalNumber, serialNumber, simpleDate, simpleDate2, documentIssuer);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), exception);
        }
    }
}

