/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims.CountryCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public final class Birthplace
extends ClaimsSet {
    public static final String COUNTRY_CLAIM_NAME = "country";
    public static final String REGION_CLAIM_NAME = "region";
    public static final String LOCALITY_CLAIM_NAME = "locality";
    private static final Set<String> stdClaimNames = new LinkedHashSet<String>();

    public static Set<String> getStandardClaimNames() {
        return Collections.unmodifiableSet(stdClaimNames);
    }

    public Birthplace(CountryCode countryCode, String string, String string2) {
        if (countryCode != null) {
            this.setClaim(COUNTRY_CLAIM_NAME, countryCode.getValue());
        }
        this.setClaim(REGION_CLAIM_NAME, string);
        this.setClaim(LOCALITY_CLAIM_NAME, string2);
    }

    public Birthplace(JSONObject jSONObject) {
        super(jSONObject);
    }

    public CountryCode getCountry() {
        String string = this.getStringClaim(COUNTRY_CLAIM_NAME);
        if (string == null) {
            return null;
        }
        try {
            return CountryCode.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setCountry(CountryCode countryCode) {
        if (countryCode != null) {
            this.setClaim(COUNTRY_CLAIM_NAME, countryCode.getValue());
        } else {
            this.setClaim(COUNTRY_CLAIM_NAME, null);
        }
    }

    public String getRegion() {
        return this.getStringClaim(REGION_CLAIM_NAME);
    }

    public void setRegion(String string) {
        this.setClaim(REGION_CLAIM_NAME, string);
    }

    public String getLocality() {
        return this.getStringClaim(LOCALITY_CLAIM_NAME);
    }

    public void setLocality(String string) {
        this.setClaim(LOCALITY_CLAIM_NAME, string);
    }

    static {
        stdClaimNames.add(LOCALITY_CLAIM_NAME);
        stdClaimNames.add(REGION_CLAIM_NAME);
        stdClaimNames.add(COUNTRY_CLAIM_NAME);
    }
}

