/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date.DateWithTimeZoneOffset;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.IdentityAssuranceLevel;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.IdentityAssuranceProcess;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.IdentityTrustFramework;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.VerificationProcess;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidence;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class IdentityVerification
implements JSONAware {
    private final IdentityTrustFramework trustFramework;
    private final IdentityAssuranceLevel assuranceLevel;
    private final IdentityAssuranceProcess assuranceProcess;
    private final DateWithTimeZoneOffset time;
    private final VerificationProcess verificationProcess;
    private final List<IdentityEvidence> evidence;

    @Deprecated
    public IdentityVerification(IdentityTrustFramework identityTrustFramework, DateWithTimeZoneOffset dateWithTimeZoneOffset, VerificationProcess verificationProcess, IdentityEvidence identityEvidence) {
        this(identityTrustFramework, dateWithTimeZoneOffset, verificationProcess, Collections.singletonList(identityEvidence));
    }

    public IdentityVerification(IdentityTrustFramework identityTrustFramework, IdentityAssuranceLevel identityAssuranceLevel, IdentityAssuranceProcess identityAssuranceProcess, DateWithTimeZoneOffset dateWithTimeZoneOffset, VerificationProcess verificationProcess, IdentityEvidence identityEvidence) {
        this(identityTrustFramework, identityAssuranceLevel, identityAssuranceProcess, dateWithTimeZoneOffset, verificationProcess, Collections.singletonList(identityEvidence));
    }

    @Deprecated
    public IdentityVerification(IdentityTrustFramework identityTrustFramework, DateWithTimeZoneOffset dateWithTimeZoneOffset, VerificationProcess verificationProcess, List<IdentityEvidence> list) {
        this(identityTrustFramework, null, null, dateWithTimeZoneOffset, verificationProcess, list);
    }

    public IdentityVerification(IdentityTrustFramework identityTrustFramework, IdentityAssuranceLevel identityAssuranceLevel, IdentityAssuranceProcess identityAssuranceProcess, DateWithTimeZoneOffset dateWithTimeZoneOffset, VerificationProcess verificationProcess, List<IdentityEvidence> list) {
        if (identityTrustFramework == null) {
            throw new IllegalArgumentException("The trust framework must not be null");
        }
        this.trustFramework = identityTrustFramework;
        this.assuranceLevel = identityAssuranceLevel;
        this.assuranceProcess = identityAssuranceProcess;
        this.time = dateWithTimeZoneOffset;
        this.verificationProcess = verificationProcess;
        this.evidence = list;
    }

    public IdentityTrustFramework getTrustFramework() {
        return this.trustFramework;
    }

    public IdentityAssuranceLevel getAssuranceLevel() {
        return this.assuranceLevel;
    }

    public IdentityAssuranceProcess getAssuranceProcess() {
        return this.assuranceProcess;
    }

    public DateWithTimeZoneOffset getVerificationTime() {
        return this.time;
    }

    public VerificationProcess getVerificationProcess() {
        return this.verificationProcess;
    }

    public List<IdentityEvidence> getEvidence() {
        return this.evidence;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("trust_framework", this.getTrustFramework().getValue());
        if (this.getAssuranceLevel() != null) {
            jSONObject.put("assurance_level", this.getAssuranceLevel().getValue());
        }
        if (this.getAssuranceProcess() != null) {
            jSONObject.put("assurance_process", this.getAssuranceProcess().toJSONObject());
        }
        if (this.getVerificationTime() != null) {
            jSONObject.put("time", this.getVerificationTime().toISO8601String());
        }
        if (this.getVerificationProcess() != null) {
            jSONObject.put("verification_process", this.getVerificationProcess().getValue());
        }
        if (this.getEvidence() != null) {
            JSONArray jSONArray = new JSONArray();
            for (IdentityEvidence identityEvidence : this.getEvidence()) {
                if (identityEvidence == null) continue;
                jSONArray.add(identityEvidence.toJSONObject());
            }
            if (!jSONArray.isEmpty()) {
                jSONObject.put("evidence", jSONArray);
            }
        }
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public static IdentityVerification parse(JSONObject jSONObject) throws ParseException {
        IdentityTrustFramework identityTrustFramework = new IdentityTrustFramework(JSONObjectUtils.getString(jSONObject, "trust_framework"));
        IdentityAssuranceLevel identityAssuranceLevel = null;
        String string = JSONObjectUtils.getString(jSONObject, "assurance_level", null);
        if (StringUtils.isNotBlank(string)) {
            identityAssuranceLevel = new IdentityAssuranceLevel(string);
        }
        IdentityAssuranceProcess identityAssuranceProcess = null;
        JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, "assurance_process", null);
        if (jSONObject2 != null) {
            identityAssuranceProcess = IdentityAssuranceProcess.parse(jSONObject2);
        }
        DateWithTimeZoneOffset dateWithTimeZoneOffset = null;
        string = JSONObjectUtils.getString(jSONObject, "time", null);
        if (StringUtils.isNotBlank(string)) {
            dateWithTimeZoneOffset = DateWithTimeZoneOffset.parseISO8601String(string);
        }
        VerificationProcess verificationProcess = null;
        string = JSONObjectUtils.getString(jSONObject, "verification_process", null);
        if (StringUtils.isNotBlank(string)) {
            verificationProcess = new VerificationProcess(string);
        }
        LinkedList<IdentityEvidence> linkedList = null;
        if (jSONObject.get("evidence") != null) {
            linkedList = new LinkedList<IdentityEvidence>();
            JSONArray jSONArray = JSONObjectUtils.getJSONArray(jSONObject, "evidence");
            for (JSONObject jSONObject3 : JSONArrayUtils.toJSONObjectList(jSONArray)) {
                linkedList.add(IdentityEvidence.parse(jSONObject3));
            }
        }
        return new IdentityVerification(identityTrustFramework, identityAssuranceLevel, identityAssuranceProcess, dateWithTimeZoneOffset, verificationProcess, linkedList);
    }
}

