/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class TokenTypeURI
implements Serializable {
    private static final long serialVersionUID = 1371197657238309877L;
    public static final TokenTypeURI ACCESS_TOKEN = new TokenTypeURI(URI.create("urn:ietf:params:oauth:token-type:access_token"));
    public static final TokenTypeURI REFRESH_TOKEN = new TokenTypeURI(URI.create("urn:ietf:params:oauth:token-type:refresh_token"));
    public static final TokenTypeURI ID_TOKEN = new TokenTypeURI(URI.create("urn:ietf:params:oauth:token-type:id_token"));
    public static final TokenTypeURI SAML1 = new TokenTypeURI(URI.create("urn:ietf:params:oauth:token-type:saml1"));
    public static final TokenTypeURI SAML2 = new TokenTypeURI(URI.create("urn:ietf:params:oauth:token-type:saml2"));
    public static final TokenTypeURI JWT = new TokenTypeURI(URI.create("urn:ietf:params:oauth:token-type:jwt"));
    private static final Map<String, TokenTypeURI> KNOWN_TOKEN_TYPE_URIS;
    private final URI uri;

    private TokenTypeURI(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        this.uri = uRI;
    }

    public URI getURI() {
        return this.uri;
    }

    public static TokenTypeURI parse(String string) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("The URI value must not be null");
        }
        TokenTypeURI tokenTypeURI = KNOWN_TOKEN_TYPE_URIS.get(string);
        if (tokenTypeURI != null) {
            return tokenTypeURI;
        }
        try {
            return new TokenTypeURI(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException("Illegal token type URI: " + string);
        }
    }

    public String toString() {
        return this.getURI().toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TokenTypeURI tokenTypeURI = (TokenTypeURI)object;
        return this.uri.equals(tokenTypeURI.getURI());
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    static {
        HashMap<String, TokenTypeURI> hashMap = new HashMap<String, TokenTypeURI>();
        hashMap.put(ACCESS_TOKEN.getURI().toString(), ACCESS_TOKEN);
        hashMap.put(REFRESH_TOKEN.getURI().toString(), REFRESH_TOKEN);
        hashMap.put(ID_TOKEN.getURI().toString(), ID_TOKEN);
        hashMap.put(SAML1.getURI().toString(), SAML1);
        hashMap.put(SAML2.getURI().toString(), SAML2);
        hashMap.put(JWT.getURI().toString(), JWT);
        KNOWN_TOKEN_TYPE_URIS = Collections.unmodifiableMap(hashMap);
    }
}

