/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token;

import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.AuthorizationDetail;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class DPoPAccessToken
extends AccessToken {
    private static final long serialVersionUID = 7745184045632691024L;

    public DPoPAccessToken(String string) {
        this(string, 0L, null);
    }

    public DPoPAccessToken(String string, long l2, Scope scope) {
        this(string, l2, scope, null);
    }

    public DPoPAccessToken(String string, long l2, Scope scope, TokenTypeURI tokenTypeURI) {
        super(AccessTokenType.DPOP, string, l2, scope, tokenTypeURI);
    }

    public DPoPAccessToken(String string, long l2, Scope scope, List<AuthorizationDetail> list, TokenTypeURI tokenTypeURI) {
        super(AccessTokenType.DPOP, string, l2, scope, list, tokenTypeURI);
    }

    @Override
    public String toAuthorizationHeader() {
        return "DPoP " + this.getValue();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DPoPAccessToken && this.toString().equals(object.toString());
    }

    public static DPoPAccessToken parse(JSONObject jSONObject) throws ParseException {
        AccessTokenUtils.parseAndEnsureType(jSONObject, AccessTokenType.DPOP);
        String string = AccessTokenUtils.parseValue(jSONObject);
        long l2 = AccessTokenUtils.parseLifetime(jSONObject);
        Scope scope = AccessTokenUtils.parseScope(jSONObject);
        List<AuthorizationDetail> list = AccessTokenUtils.parseAuthorizationDetails(jSONObject);
        TokenTypeURI tokenTypeURI = AccessTokenUtils.parseIssuedTokenType(jSONObject);
        return new DPoPAccessToken(string, l2, scope, list, tokenTypeURI);
    }

    public static DPoPAccessToken parse(String string) throws ParseException {
        return new DPoPAccessToken(AccessTokenUtils.parseValueFromHeader(string, AccessTokenType.DPOP));
    }

    public static DPoPAccessToken parse(Map<String, List<String>> map) throws ParseException {
        return new DPoPAccessToken(AccessTokenUtils.parseValueFromQueryParameters(map, AccessTokenType.DPOP));
    }

    public static DPoPAccessToken parse(HTTPRequest hTTPRequest) throws ParseException {
        String string = hTTPRequest.getAuthorization();
        if (string != null) {
            return DPoPAccessToken.parse(string);
        }
        Map<String, List<String>> map = hTTPRequest.getQueryParameters();
        return DPoPAccessToken.parse(map);
    }
}

