/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.cnf.AbstractConfirmation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class JWKThumbprintConfirmation
extends AbstractConfirmation {
    private final Base64URL jkt;

    public JWKThumbprintConfirmation(Base64URL base64URL) {
        if (base64URL == null) {
            throw new IllegalArgumentException("The JWK thumbprint must not be null");
        }
        this.jkt = base64URL;
    }

    public Base64URL getValue() {
        return this.jkt;
    }

    @Override
    public Map.Entry<String, JSONObject> toJWTClaim() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("jkt", this.jkt.toString());
        return new AbstractMap.SimpleImmutableEntry<String, JSONObject>("cnf", jSONObject);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JWKThumbprintConfirmation)) {
            return false;
        }
        JWKThumbprintConfirmation jWKThumbprintConfirmation = (JWKThumbprintConfirmation)object;
        return this.jkt.equals(jWKThumbprintConfirmation.jkt);
    }

    public int hashCode() {
        return Objects.hash(this.jkt);
    }

    public static JWKThumbprintConfirmation parse(JWTClaimsSet jWTClaimsSet) {
        JSONObject jSONObject = JWKThumbprintConfirmation.parseConfirmationJSONObject(jWTClaimsSet);
        if (jSONObject == null) {
            return null;
        }
        return JWKThumbprintConfirmation.parseFromConfirmationJSONObject(jSONObject);
    }

    public static JWKThumbprintConfirmation parse(JSONObject jSONObject) {
        if (!jSONObject.containsKey("cnf")) {
            return null;
        }
        try {
            return JWKThumbprintConfirmation.parseFromConfirmationJSONObject(JSONObjectUtils.getJSONObject(jSONObject, "cnf"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static JWKThumbprintConfirmation parseFromConfirmationJSONObject(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        try {
            String string = JSONObjectUtils.getString(jSONObject, "jkt");
            return new JWKThumbprintConfirmation(new Base64URL(string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static JWKThumbprintConfirmation of(JWK jWK) throws JOSEException {
        return new JWKThumbprintConfirmation(jWK.computeThumbprint());
    }
}

