/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop;

import java.net.URI;
import java.security.Provider;
import java.util.Date;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.DPoPProofFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.DPoPUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Nonce;

public class DefaultDPoPProofFactory
implements DPoPProofFactory {
    private final JWK publicJWK;
    private final JWSAlgorithm jwsAlg;
    private final JWSSigner jwsSigner;

    public DefaultDPoPProofFactory(JWK jWK, JWSAlgorithm jWSAlgorithm) throws JOSEException {
        this(jWK, jWSAlgorithm, null);
    }

    public DefaultDPoPProofFactory(JWK jWK, JWSAlgorithm jWSAlgorithm, Provider provider) throws JOSEException {
        if (!jWK.isPrivate()) {
            throw new IllegalArgumentException("The JWK must include private parameters");
        }
        if (!JWSAlgorithm.Family.SIGNATURE.contains(jWSAlgorithm)) {
            throw new IllegalArgumentException("The JWS algorithm must be for a digital signature");
        }
        this.jwsAlg = jWSAlgorithm;
        DefaultJWSSignerFactory defaultJWSSignerFactory = new DefaultJWSSignerFactory();
        if (provider != null) {
            defaultJWSSignerFactory.getJCAContext().setProvider(provider);
        }
        this.jwsSigner = defaultJWSSignerFactory.createJWSSigner(jWK, jWSAlgorithm);
        this.publicJWK = jWK.toPublicJWK();
    }

    public JWK getPublicJWK() {
        return this.publicJWK;
    }

    public JWSAlgorithm getJWSAlgorithm() {
        return this.jwsAlg;
    }

    public JWSSigner getJWSSigner() {
        return this.jwsSigner;
    }

    @Override
    public SignedJWT createDPoPJWT(String string, URI uRI) throws JOSEException {
        return this.createDPoPJWT(string, uRI, null, null);
    }

    @Override
    public SignedJWT createDPoPJWT(String string, URI uRI, Nonce nonce) throws JOSEException {
        return this.createDPoPJWT(string, uRI, null, nonce);
    }

    @Override
    public SignedJWT createDPoPJWT(String string, URI uRI, AccessToken accessToken) throws JOSEException {
        return this.createDPoPJWT(string, uRI, accessToken, null);
    }

    @Override
    public SignedJWT createDPoPJWT(String string, URI uRI, AccessToken accessToken, Nonce nonce) throws JOSEException {
        return this.createDPoPJWT(new JWTID(12), string, uRI, new Date(), accessToken, nonce);
    }

    @Override
    public SignedJWT createDPoPJWT(JWTID jWTID, String string, URI uRI, Date date, AccessToken accessToken) throws JOSEException {
        return this.createDPoPJWT(jWTID, string, uRI, date, accessToken, null);
    }

    @Override
    public SignedJWT createDPoPJWT(JWTID jWTID, String string, URI uRI, Date date, AccessToken accessToken, Nonce nonce) throws JOSEException {
        JWSHeader jWSHeader = new JWSHeader.Builder(this.getJWSAlgorithm()).type(TYPE).jwk(this.getPublicJWK()).build();
        JWTClaimsSet jWTClaimsSet = DPoPUtils.createJWTClaimsSet(jWTID, string, uRI, date, accessToken, nonce);
        SignedJWT signedJWT = new SignedJWT(jWSHeader, jWTClaimsSet);
        signedJWT.sign(this.getJWSSigner());
        return signedJWT;
    }
}

