/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class ClientUpdateRequest
extends ProtectedResourceRequest {
    private final ClientID id;
    private final ClientMetadata metadata;
    private final Secret secret;

    public ClientUpdateRequest(URI uRI, ClientID clientID, BearerAccessToken bearerAccessToken, ClientMetadata clientMetadata, Secret secret) {
        super(uRI, bearerAccessToken);
        if (clientID == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.id = clientID;
        if (clientMetadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = clientMetadata;
        this.secret = secret;
    }

    public ClientID getClientID() {
        return this.id;
    }

    public ClientMetadata getClientMetadata() {
        return this.metadata;
    }

    public Secret getClientSecret() {
        return this.secret;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.PUT, this.getEndpointURI());
        hTTPRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_JSON);
        JSONObject jSONObject = this.metadata.toJSONObject();
        jSONObject.put("client_id", this.id.getValue());
        if (this.secret != null) {
            jSONObject.put("client_secret", this.secret.getValue());
        }
        hTTPRequest.setBody(jSONObject.toString());
        return hTTPRequest;
    }

    public static ClientUpdateRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.PUT);
        BearerAccessToken bearerAccessToken = BearerAccessToken.parse(hTTPRequest.getAuthorization());
        JSONObject jSONObject = hTTPRequest.getBodyAsJSONObject();
        ClientID clientID = new ClientID(JSONObjectUtils.getString(jSONObject, "client_id"));
        ClientMetadata clientMetadata = ClientMetadata.parse(jSONObject);
        Secret secret = null;
        if (jSONObject.get("client_secret") != null) {
            secret = new Secret(JSONObjectUtils.getString(jSONObject, "client_secret"));
        }
        return new ClientUpdateRequest(hTTPRequest.getURI(), clientID, bearerAccessToken, clientMetadata, secret);
    }
}

