/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SuccessResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.AuthRequestID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBAResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class CIBARequestAcknowledgement
extends CIBAResponse
implements SuccessResponse {
    public static final int DEFAULT_MIN_WAIT_INTERVAL = 5;
    private final AuthRequestID authRequestID;
    private final int expiresIn;
    private final Integer minWaitInterval;

    public CIBARequestAcknowledgement(AuthRequestID authRequestID, int n2, Integer n3) {
        if (authRequestID == null) {
            throw new IllegalArgumentException("The auth_req_id must not be null");
        }
        this.authRequestID = authRequestID;
        if (n2 < 1) {
            throw new IllegalArgumentException("The expiration must be a positive integer");
        }
        this.expiresIn = n2;
        if (n3 != null && n3 < 1) {
            throw new IllegalArgumentException("The interval must be a positive integer");
        }
        this.minWaitInterval = n3;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public AuthRequestID getAuthRequestID() {
        return this.authRequestID;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public Integer getMinWaitInterval() {
        return this.minWaitInterval;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("auth_req_id", this.authRequestID);
        jSONObject.put("expires_in", this.expiresIn);
        if (this.minWaitInterval != null) {
            jSONObject.put("interval", this.minWaitInterval);
        }
        return jSONObject;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = new HTTPResponse(200);
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        hTTPResponse.setContent(this.toJSONObject().toString());
        return hTTPResponse;
    }

    public static CIBARequestAcknowledgement parse(JSONObject jSONObject) throws ParseException {
        AuthRequestID authRequestID = AuthRequestID.parse(JSONObjectUtils.getString(jSONObject, "auth_req_id"));
        int n2 = JSONObjectUtils.getInt(jSONObject, "expires_in");
        if (n2 < 1) {
            throw new ParseException("The expires_in parameter must be a positive integer");
        }
        Integer n3 = null;
        if (jSONObject.get("interval") != null) {
            n3 = JSONObjectUtils.getInt(jSONObject, "interval");
        }
        if (n3 != null && n3 < 1) {
            throw new ParseException("The interval parameter must be a positive integer");
        }
        return new CIBARequestAcknowledgement(authRequestID, n2, n3);
    }

    public static CIBARequestAcknowledgement parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCode(200);
        JSONObject jSONObject = hTTPResponse.getContentAsJSONObject();
        return CIBARequestAcknowledgement.parse(jSONObject);
    }
}

