/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBAError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBAResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class CIBAErrorResponse
extends CIBAResponse
implements ErrorResponse {
    private static final Set<ErrorObject> STANDARD_ERRORS;
    private final ErrorObject error;

    public static Set<ErrorObject> getStandardErrors() {
        return STANDARD_ERRORS;
    }

    protected CIBAErrorResponse() {
        this.error = null;
    }

    public CIBAErrorResponse(ErrorObject errorObject) {
        if (errorObject == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = errorObject;
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    public JSONObject toJSONObject() {
        if (this.error != null) {
            return this.error.toJSONObject();
        }
        return new JSONObject();
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        int n2 = this.error != null && this.error.getHTTPStatusCode() > 0 ? this.error.getHTTPStatusCode() : 400;
        HTTPResponse hTTPResponse = new HTTPResponse(n2);
        if (this.error == null) {
            return hTTPResponse;
        }
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        hTTPResponse.setContent(this.toJSONObject().toString());
        return hTTPResponse;
    }

    public static CIBAErrorResponse parse(JSONObject jSONObject) throws ParseException {
        if (!jSONObject.containsKey("error")) {
            return new CIBAErrorResponse();
        }
        return new CIBAErrorResponse(ErrorObject.parse(jSONObject));
    }

    public static CIBAErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCodeNotOK();
        return new CIBAErrorResponse(ErrorObject.parse(hTTPResponse));
    }

    static {
        HashSet<ErrorObject> hashSet = new HashSet<ErrorObject>();
        hashSet.add(OAuth2Error.INVALID_REQUEST);
        hashSet.add(OAuth2Error.INVALID_SCOPE);
        hashSet.add(OAuth2Error.INVALID_CLIENT);
        hashSet.add(OAuth2Error.UNAUTHORIZED_CLIENT);
        hashSet.add(OAuth2Error.ACCESS_DENIED);
        hashSet.add(CIBAError.EXPIRED_LOGIN_HINT_TOKEN);
        hashSet.add(CIBAError.UNKNOWN_USER_ID);
        hashSet.add(CIBAError.MISSING_USER_CODE);
        hashSet.add(CIBAError.INVALID_USER_CODE);
        hashSet.add(CIBAError.INVALID_BINDING_MESSAGE);
        STANDARD_ERRORS = Collections.unmodifiableSet(hashSet);
    }
}

