/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.util.Date;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetails;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class JWTAuthenticationClaimsSet
extends JWTAssertionDetails {
    public JWTAuthenticationClaimsSet(ClientID clientID, Audience audience) {
        this(clientID, audience.toSingleAudienceList(), new Date(new Date().getTime() + 60000L), null, null, new JWTID());
    }

    public JWTAuthenticationClaimsSet(Issuer issuer, ClientID clientID, Audience audience) {
        this(issuer, clientID, audience.toSingleAudienceList(), new Date(new Date().getTime() + 60000L), null, null, new JWTID());
    }

    public JWTAuthenticationClaimsSet(ClientID clientID, List<Audience> list, Date date, Date date2, Date date3, JWTID jWTID) {
        super(new Issuer(clientID.getValue()), new Subject(clientID.getValue()), list, date, date2, date3, jWTID, null);
    }

    public JWTAuthenticationClaimsSet(Issuer issuer, ClientID clientID, List<Audience> list, Date date, Date date2, Date date3, JWTID jWTID) {
        super(issuer, new Subject(clientID.getValue()), list, date, date2, date3, jWTID, null);
    }

    public ClientID getClientID() {
        return new ClientID(this.getSubject());
    }

    public static JWTAuthenticationClaimsSet parse(JSONObject jSONObject) throws ParseException {
        JWTAssertionDetails jWTAssertionDetails = JWTAssertionDetails.parse(jSONObject);
        return new JWTAuthenticationClaimsSet(jWTAssertionDetails.getIssuer(), new ClientID(jWTAssertionDetails.getSubject()), jWTAssertionDetails.getAudience(), jWTAssertionDetails.getExpirationTime(), jWTAssertionDetails.getNotBeforeTime(), jWTAssertionDetails.getIssueTime(), jWTAssertionDetails.getJWTID());
    }

    public static JWTAuthenticationClaimsSet parse(JWTClaimsSet jWTClaimsSet) throws ParseException {
        return JWTAuthenticationClaimsSet.parse(JSONObjectUtils.toJSONObject(jWTClaimsSet));
    }
}

