/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.JWTAuthenticationClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;

public abstract class JWTAuthentication
extends ClientAuthentication {
    public static final String CLIENT_ASSERTION_TYPE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private final SignedJWT clientAssertion;
    private final JWTAuthenticationClaimsSet jwtAuthClaimsSet;

    private static ClientID parseClientID(SignedJWT signedJWT) {
        String string;
        String string2;
        try {
            string2 = signedJWT.getJWTClaimsSet().getSubject();
            string = signedJWT.getJWTClaimsSet().getIssuer();
        }
        catch (java.text.ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage(), parseException);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Missing subject in client JWT assertion");
        }
        if (string == null) {
            throw new IllegalArgumentException("Missing issuer in client JWT assertion");
        }
        return new ClientID(string2);
    }

    protected JWTAuthentication(ClientAuthenticationMethod clientAuthenticationMethod, SignedJWT signedJWT) {
        super(clientAuthenticationMethod, JWTAuthentication.parseClientID(signedJWT));
        if (!signedJWT.getState().equals((Object)JWSObject.State.SIGNED)) {
            throw new IllegalArgumentException("The client assertion JWT must be signed");
        }
        this.clientAssertion = signedJWT;
        try {
            this.jwtAuthClaimsSet = JWTAuthenticationClaimsSet.parse(signedJWT.getJWTClaimsSet());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
    }

    public SignedJWT getClientAssertion() {
        return this.clientAssertion;
    }

    public JWTAuthenticationClaimsSet getJWTAuthenticationClaimsSet() {
        return this.jwtAuthClaimsSet;
    }

    @Override
    public Set<String> getFormParameterNames() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("client_assertion", "client_assertion_type", "client_id")));
    }

    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        try {
            hashMap.put("client_assertion", Collections.singletonList(this.clientAssertion.serialize()));
        }
        catch (IllegalStateException illegalStateException) {
            throw new SerializeException("Couldn't serialize JWT to a client assertion string: " + illegalStateException.getMessage(), illegalStateException);
        }
        hashMap.put("client_assertion_type", Collections.singletonList(CLIENT_ASSERTION_TYPE));
        return hashMap;
    }

    @Override
    public void applyTo(HTTPRequest hTTPRequest) {
        LinkedHashMap<String, List<String>> linkedHashMap;
        if (hTTPRequest.getMethod() != HTTPRequest.Method.POST) {
            throw new SerializeException("The HTTP request method must be POST");
        }
        ContentType contentType = hTTPRequest.getEntityContentType();
        if (contentType == null) {
            throw new SerializeException("Missing HTTP Content-Type header");
        }
        if (!contentType.matches(ContentType.APPLICATION_URLENCODED)) {
            throw new SerializeException("The HTTP Content-Type header must be " + ContentType.APPLICATION_URLENCODED);
        }
        try {
            linkedHashMap = new LinkedHashMap<String, List<String>>(hTTPRequest.getBodyAsFormParameters());
        }
        catch (ParseException parseException) {
            throw new SerializeException(parseException.getMessage(), parseException);
        }
        linkedHashMap.putAll(this.toParameters());
        hTTPRequest.setBody(URLUtils.serializeParameters(linkedHashMap));
    }

    protected static void ensureClientAssertionType(Map<String, List<String>> map) throws ParseException {
        String string = MultivaluedMapUtils.getFirstValue(map, "client_assertion_type");
        if (string == null) {
            throw new ParseException("Missing client_assertion_type parameter");
        }
        if (!string.equals(CLIENT_ASSERTION_TYPE)) {
            throw new ParseException("Invalid client_assertion_type parameter, must be urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        }
    }

    protected static SignedJWT parseClientAssertion(Map<String, List<String>> map) throws ParseException {
        String string = MultivaluedMapUtils.getFirstValue(map, "client_assertion");
        if (string == null) {
            throw new ParseException("Missing client_assertion parameter");
        }
        try {
            return SignedJWT.parse(string);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid client_assertion JWT: " + parseException.getMessage(), parseException);
        }
    }

    protected static ClientID parseClientID(Map<String, List<String>> map) {
        String string = MultivaluedMapUtils.getFirstValue(map, "client_id");
        return string != null ? new ClientID(string) : null;
    }

    public static JWTAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        String string = hTTPRequest.getQuery();
        if (string == null) {
            throw new ParseException("Missing HTTP POST request entity body");
        }
        Map<String, List<String>> map = URLUtils.parseParameters(string);
        JWSAlgorithm jWSAlgorithm = JWTAuthentication.parseClientAssertion(map).getHeader().getAlgorithm();
        if (ClientSecretJWT.supportedJWAs().contains(jWSAlgorithm)) {
            return ClientSecretJWT.parse(map);
        }
        if (PrivateKeyJWT.supportedJWAs().contains(jWSAlgorithm)) {
            return PrivateKeyJWT.parse(map);
        }
        throw new ParseException("Unsupported signed JWT algorithm: " + jWSAlgorithm);
    }
}

