/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.PKITLSClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.SelfSignedTLSClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;

public abstract class ClientAuthentication {
    private final ClientAuthenticationMethod method;
    private final ClientID clientID;

    protected ClientAuthentication(ClientAuthenticationMethod clientAuthenticationMethod, ClientID clientID) {
        if (clientAuthenticationMethod == null) {
            throw new IllegalArgumentException("The client authentication method must not be null");
        }
        this.method = clientAuthenticationMethod;
        if (clientID == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.clientID = clientID;
    }

    public ClientAuthenticationMethod getMethod() {
        return this.method;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public abstract Set<String> getFormParameterNames();

    public static ClientAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        if (hTTPRequest.getAuthorization() != null && hTTPRequest.getAuthorization().startsWith("Basic")) {
            return ClientSecretBasic.parse(hTTPRequest);
        }
        if (hTTPRequest.getMethod() != HTTPRequest.Method.POST && !hTTPRequest.getEntityContentType().matches(ContentType.APPLICATION_URLENCODED)) {
            return null;
        }
        Map map = hTTPRequest.getBodyAsFormParameters();
        if (StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(map, "client_id")) && StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(map, "client_secret"))) {
            return ClientSecretPost.parse(hTTPRequest);
        }
        if (StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(map, "client_assertion")) && StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(map, "client_assertion_type"))) {
            return JWTAuthentication.parse(hTTPRequest);
        }
        if (hTTPRequest.getClientX509Certificate() != null && StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(map, "client_id"))) {
            X500Principal x500Principal = hTTPRequest.getClientX509Certificate().getIssuerX500Principal();
            X500Principal x500Principal2 = hTTPRequest.getClientX509Certificate().getSubjectX500Principal();
            if (x500Principal != null && x500Principal.equals(x500Principal2)) {
                if (hTTPRequest.getClientX509CertificateRootDN() != null && !hTTPRequest.getClientX509CertificateRootDN().equalsIgnoreCase(x500Principal.toString())) {
                    throw new ParseException("Client X.509 certificate issuer DN doesn't match HTTP request metadata");
                }
                if (hTTPRequest.getClientX509CertificateSubjectDN() != null && !hTTPRequest.getClientX509CertificateSubjectDN().equalsIgnoreCase(x500Principal2.toString())) {
                    throw new ParseException("Client X.509 certificate subject DN doesn't match HTTP request metadata");
                }
                return SelfSignedTLSClientAuthentication.parse(hTTPRequest);
            }
            return PKITLSClientAuthentication.parse(hTTPRequest);
        }
        return null;
    }

    public abstract void applyTo(HTTPRequest var1);
}

